/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.awt.geom.Area;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LatLon
extends Coordinate {
    public static final double MAX_SERVER_PRECISION = 1.0E-7;
    public static final double MAX_SERVER_INV_PRECISION = 1.0E7;
    public static final int MAX_SERVER_DIGITS = 7;
    public static final LatLon ZERO = new LatLon(0.0, 0.0);
    private static DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static DecimalFormat cDmsSecondFormatter = new DecimalFormat("00.0");
    private static DecimalFormat cDmMinuteFormatter = new DecimalFormat("00.000");
    public static final DecimalFormat cDdFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
    private static final String cDms60;
    private static final String cDms00;
    private static final String cDm60;
    private static final String cDm00;
    public static final String SOUTH;
    public static final String NORTH;
    public static final String WEST;
    public static final String EAST;

    public static boolean isValidLat(double d) {
        return d >= -90.0 && d <= 90.0;
    }

    public static boolean isValidLon(double d) {
        return d >= -180.0 && d <= 180.0;
    }

    public boolean isValid() {
        return LatLon.isValidLat(this.lat()) && LatLon.isValidLon(this.lon());
    }

    public static double toIntervalLat(double d) {
        if (d < -90.0) {
            return -90.0;
        }
        if (d > 90.0) {
            return 90.0;
        }
        return d;
    }

    public static double toIntervalLon(double d) {
        if (LatLon.isValidLon(d)) {
            return d;
        }
        int n = (int)(d + Math.signum(d) * 180.0) / 360;
        return d - (double)n * 360.0;
    }

    public static String dms(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        int n2 = (int)d3;
        double d4 = (d3 - (double)n2) * 60.0;
        String string = Integer.toString(n);
        String string2 = cDmsMinuteFormatter.format(n2);
        String string3 = cDmsSecondFormatter.format(d4);
        if (string3.equals(cDms60)) {
            string3 = cDms00;
            string2 = cDmsMinuteFormatter.format(n2 + 1);
        }
        if (string2.equals("60")) {
            string2 = "00";
            string = Integer.toString(n + 1);
        }
        return string + "\u00b0" + string2 + "'" + string3 + "\"";
    }

    public static String dm(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        String string = Integer.toString(n);
        String string2 = cDmMinuteFormatter.format(d3);
        if (string2.equals(cDm60)) {
            string2 = cDm00;
            string = Integer.toString(n + 1);
        }
        return string + "\u00b0" + string2 + "'";
    }

    public LatLon(double d, double d2) {
        super(d2, d);
    }

    protected LatLon(LatLon latLon) {
        super(latLon.lon(), latLon.lat());
    }

    public double lat() {
        return this.y;
    }

    public String latToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.y);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case NAUTICAL: {
                return LatLon.dm(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.getProjection().latlon2eastNorth(this).north());
            }
        }
        return "ERR";
    }

    public double lon() {
        return this.x;
    }

    public String lonToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.x);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case NAUTICAL: {
                return LatLon.dm(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.getProjection().latlon2eastNorth(this).east());
            }
        }
        return "ERR";
    }

    public boolean equalsEpsilon(LatLon latLon) {
        double d = 5.0E-8;
        return Math.abs(this.lat() - latLon.lat()) <= d && Math.abs(this.lon() - latLon.lon()) <= d;
    }

    public boolean isOutSideWorld() {
        Bounds bounds = Main.getProjection().getWorldBoundsLatLon();
        return this.lat() < bounds.getMinLat() || this.lat() > bounds.getMaxLat() || this.lon() < bounds.getMinLon() || this.lon() > bounds.getMaxLon();
    }

    public boolean isWithin(Bounds bounds) {
        return bounds.contains(this);
    }

    public boolean isIn(Area area) {
        return area == null || area.contains(this.x, this.y);
    }

    public double greatCircleDistance(LatLon latLon) {
        double d = 6378135.0;
        double d2 = Math.sin(Math.toRadians(latLon.lat() - this.lat()) / 2.0);
        double d3 = Math.sin(Math.toRadians(latLon.lon() - this.lon()) / 2.0);
        double d4 = 2.0 * d * Math.asin(Math.sqrt(d2 * d2 + Math.cos(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(latLon.lat())) * d3 * d3));
        if (Double.isNaN(d4)) {
            Main.error("NaN in greatCircleDistance");
            d4 = Math.PI * d;
        }
        return d4;
    }

    public double heading(LatLon latLon) {
        double d = Math.atan2(Math.sin(Math.toRadians(this.lon() - latLon.lon())) * Math.cos(Math.toRadians(latLon.lat())), Math.cos(Math.toRadians(this.lat())) * Math.sin(Math.toRadians(latLon.lat())) - Math.sin(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(latLon.lat())) * Math.cos(Math.toRadians(this.lon() - latLon.lon())));
        if ((d %= Math.PI * 2) < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public String toDisplayString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        return "lat=" + numberFormat.format(this.lat()) + "\u00b0, lon=" + numberFormat.format(this.lon()) + "\u00b0";
    }

    public String toStringCSV(String string) {
        return Utils.join(string, Arrays.asList(this.latToString(CoordinateFormat.DECIMAL_DEGREES), this.lonToString(CoordinateFormat.DECIMAL_DEGREES)));
    }

    public LatLon interpolate(LatLon latLon, double d) {
        return new LatLon(this.lat() + d * (latLon.lat() - this.lat()), this.lon() + d * (latLon.lon() - this.lon()));
    }

    public LatLon getCenter(LatLon latLon) {
        return new LatLon((this.lat() + latLon.lat()) / 2.0, (this.lon() + latLon.lon()) / 2.0);
    }

    public double distance(LatLon latLon) {
        return super.distance(latLon);
    }

    public double distanceSq(LatLon latLon) {
        return super.distanceSq(latLon);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }

    public static double roundToOsmPrecision(double d) {
        return (double)Math.round(d * 1.0E7) / 1.0E7;
    }

    public static double roundToOsmPrecisionStrict(double d) {
        return LatLon.roundToOsmPrecision(d);
    }

    public LatLon getRoundedToOsmPrecision() {
        return new LatLon(LatLon.roundToOsmPrecision(this.lat()), LatLon.roundToOsmPrecision(this.lon()));
    }

    public LatLon getRoundedToOsmPrecisionStrict() {
        return new LatLon(LatLon.roundToOsmPrecisionStrict(this.lat()), LatLon.roundToOsmPrecisionStrict(this.lon()));
    }

    @Override
    public int hashCode() {
        return this.computeHashCode(super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Coordinate coordinate = (Coordinate)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(coordinate.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(coordinate.y);
    }

    static {
        cDdFormatter.applyPattern("###0.0######");
        cDms60 = cDmsSecondFormatter.format(60.0);
        cDms00 = cDmsSecondFormatter.format(0.0);
        cDm60 = cDmMinuteFormatter.format(60.0);
        cDm00 = cDmMinuteFormatter.format(0.0);
        SOUTH = I18n.trc("compass", "S");
        NORTH = I18n.trc("compass", "N");
        WEST = I18n.trc("compass", "W");
        EAST = I18n.trc("compass", "E");
    }
}

