/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.corrector.Correction;
import org.openstreetmap.josm.tools.I18n;

public abstract class CorrectionTableModel<C extends Correction>
extends AbstractTableModel {
    private List<C> corrections;
    private boolean[] apply;
    private int applyColumn;

    public CorrectionTableModel(List<C> list) {
        this.corrections = list;
        this.apply = new boolean[this.corrections.size()];
        Arrays.fill(this.apply, true);
        this.applyColumn = this.getColumnCount() - 1;
    }

    @Override
    public abstract int getColumnCount();

    protected abstract boolean isBoldCell(int var1, int var2);

    public abstract String getCorrectionColumnName(int var1);

    public abstract Object getCorrectionValueAt(int var1, int var2);

    public List<C> getCorrections() {
        return this.corrections;
    }

    public int getApplyColumn() {
        return this.applyColumn;
    }

    public boolean getApply(int n) {
        return this.apply[n];
    }

    @Override
    public int getRowCount() {
        return this.corrections.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == this.applyColumn) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        if (n == this.applyColumn) {
            return I18n.tr("Apply?", new Object[0]);
        }
        return this.getCorrectionColumnName(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == this.applyColumn;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == this.applyColumn && object instanceof Boolean) {
            this.apply[n] = (Boolean)object;
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == this.applyColumn) {
            return this.apply[n];
        }
        return this.getCorrectionValueAt(n, n2);
    }
}

