/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PreferencesAction
extends JosmAction
implements Runnable {
    private final Class<? extends TabPreferenceSetting> tab;
    private final Class<? extends SubPreferenceSetting> subTab;

    private PreferencesAction(String string, String string2, Class<? extends TabPreferenceSetting> clazz, Class<? extends SubPreferenceSetting> clazz2) {
        super(string, "preference", string2, null, false, "preference_" + Utils.firstNonNull(clazz, clazz2).getName(), false);
        this.tab = clazz;
        this.subTab = clazz2;
    }

    public static PreferencesAction forPreferenceTab(String string, String string2, Class<? extends TabPreferenceSetting> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz);
        return new PreferencesAction(string, string2, clazz, null);
    }

    public static PreferencesAction forPreferenceSubTab(String string, String string2, Class<? extends SubPreferenceSetting> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz);
        return new PreferencesAction(string, string2, null, clazz);
    }

    public PreferencesAction() {
        super(I18n.tr("Preferences...", new Object[0]), "preference", I18n.tr("Open a preferences dialog for global settings.", new Object[0]), Shortcut.registerShortcut("system:preferences", I18n.tr("Preferences", new Object[0]), 123, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/Preferences"));
        this.tab = null;
        this.subTab = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.run();
    }

    @Override
    public void run() {
        PreferenceDialog preferenceDialog = new PreferenceDialog(Main.parent);
        if (this.tab != null) {
            preferenceDialog.selectPreferencesTabByClass(this.tab);
        } else if (this.subTab != null) {
            preferenceDialog.selectSubPreferencesTabByClass(this.subTab);
        }
        preferenceDialog.setVisible(true);
    }
}

