/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInLineAction
extends JosmAction {
    public AlignInLineAction() {
        super(I18n.tr("Align Nodes in Line", new Object[0]), "alignline", I18n.tr("Move the selected nodes in to a line.", new Object[0]), Shortcut.registerShortcut("tools:alignline", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Line", new Object[0])), 76, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInLine"));
    }

    private void nodePairFurthestApart(List<Node> list, Node[] nodeArray) {
        if (nodeArray.length < 2) {
            throw new IllegalArgumentException();
        }
        Node node = null;
        Node node2 = null;
        HashSet<Way> hashSet = null;
        for (Node osmPrimitive : list) {
            List<Way> i = OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Way.class);
            if (hashSet == null) {
                hashSet = new HashSet<Way>(i);
                continue;
            }
            hashSet.retainAll(i);
        }
        if (hashSet.size() == 1) {
            HashSet<Node> hashSet2 = new HashSet<Node>(list);
            Way way = (Way)hashSet.iterator().next();
            for (Node node4 : way.getNodes()) {
                if (!hashSet2.contains(node4)) continue;
                if (node == null) {
                    node = node4;
                }
                if (hashSet2.size() == 1) {
                    node2 = (Node)hashSet2.iterator().next();
                    break;
                }
                hashSet2.remove(node4);
            }
        } else {
            double d = 0.0;
            for (int i = 0; i < list.size() - 1; ++i) {
                Node node3 = list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    Node node4 = list.get(j);
                    double d2 = Math.sqrt(node3.getEastNorth().distance(node4.getEastNorth()));
                    if (!(d2 > d)) continue;
                    node = node3;
                    node2 = node4;
                    d = d2;
                }
            }
        }
        nodeArray[0] = node;
        nodeArray[1] = node2;
    }

    private void showWarning() {
        this.showWarning(I18n.tr("Please select at least three nodes.", new Object[0]));
    }

    private void showWarning(String string) {
        new Notification(string).setIcon(1).show();
    }

    private static int indexWrap(int n, int n2) {
        if ((n2 %= n) < 0) {
            n2 = n + n2;
        }
        return n2;
    }

    private static Node getNodeRelative(Way way, int n, int n2) {
        int n3 = AlignInLineAction.indexWrap(way.getNodesCount(), n + n2);
        if (way.isClosed() && n + n2 < 0) {
            --n3;
        }
        return way.getNode(n3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        Node[] nodeArray = new Node[2];
        ArrayList<Node> arrayList = new ArrayList<Node>(AlignInLineAction.getCurrentDataSet().getSelectedNodes());
        Collection<Way> collection = AlignInLineAction.getCurrentDataSet().getSelectedWays();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        if (arrayList.isEmpty() && !collection.isEmpty()) {
            this.alignMultiWay(collection);
            return;
        }
        if (arrayList.size() >= 3) {
            arrayList2.addAll(arrayList);
            this.nodePairFurthestApart(arrayList2, nodeArray);
        } else if (arrayList.size() == 1) {
            object = (Node)arrayList.iterator().next();
            Way way = null;
            if (collection.size() == 1) {
                way = collection.iterator().next();
                if (!way.containsNode((Node)object)) {
                    return;
                }
            } else {
                List<Way> list = OsmPrimitive.getFilteredList(((OsmPrimitive)object).getReferrers(), Way.class);
                if (list.size() == 1) {
                    way = list.iterator().next();
                }
            }
            if (way == null || way.getNodesCount() < 3) {
                return;
            }
            int n = way.getNodes().indexOf(object);
            if (!(n != 0 && n != way.getNodesCount() - 1 || way.isClosed())) {
                int n2 = n == 0 ? 1 : -1;
                nodeArray[0] = way.getNode(n + n2);
                nodeArray[1] = way.getNode(n + n2 * 2);
            } else {
                nodeArray[0] = AlignInLineAction.getNodeRelative(way, n, 1);
                nodeArray[1] = AlignInLineAction.getNodeRelative(way, n, -1);
            }
            arrayList2.add((Node)object);
        }
        if (nodeArray[0] == null || nodeArray[1] == null) {
            this.showWarning();
            return;
        }
        object = new ArrayList(arrayList2.size());
        this.createAlignNodesCommands(nodeArray, arrayList2, (Collection<Command>)object);
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Line", new Object[0]), (Collection<Command>)object));
        Main.map.repaint();
    }

    private void createAlignNodesCommands(Node[] nodeArray, Collection<Node> collection, Collection<Command> collection2) {
        Node node = nodeArray[0];
        Node node2 = nodeArray[1];
        collection.remove(node);
        collection.remove(node2);
        double d = node.getEastNorth().east();
        double d2 = node.getEastNorth().north();
        double d3 = node2.getEastNorth().east();
        double d4 = node2.getEastNorth().north();
        for (Node node3 : collection) {
            double d5;
            double d6;
            double d7 = node3.getEastNorth().east();
            double d8 = node3.getEastNorth().north();
            if (d == d3) {
                d7 = d;
            } else if (d2 == d4) {
                d8 = d2;
            } else {
                d6 = (d4 - d2) / (d3 - d);
                d5 = d2 - d * d6;
                double d9 = -1.0 / d6;
                double d10 = node3.getEastNorth().north() - node3.getEastNorth().east() * d9;
                d7 = (d10 - d5) / (d6 - d9);
                d8 = d6 * d7 + d5;
            }
            d6 = d7 - node3.getEastNorth().east();
            d5 = d8 - node3.getEastNorth().north();
            collection2.add(new MoveCommand((OsmPrimitive)node3, d6, d5));
        }
    }

    private void alignMultiWay(Collection<Way> collection) {
        HashSet<Node> hashSet = new HashSet<Node>();
        HashMap<Way, Line> hashMap = new HashMap<Way, Line>();
        for (Way object2 : collection) {
            if (object2.firstNode() == object2.lastNode()) {
                this.showWarning(I18n.tr("Can not align a polygon. Abort.", new Object[0]));
                return;
            }
            hashSet.addAll(object2.getNodes());
            hashMap.put(object2, new Line(object2));
        }
        ArrayList arrayList = new ArrayList(hashSet.size());
        ArrayList<Way> arrayList2 = new ArrayList<Way>(collection.size());
        for (Node node : hashSet) {
            Object object;
            arrayList2.clear();
            for (OsmPrimitive osmPrimitive : node.getReferrers()) {
                if (!collection.contains(osmPrimitive)) continue;
                arrayList2.add((Way)osmPrimitive);
            }
            if (arrayList2.size() == 1) {
                object = (Way)arrayList2.get(0);
                if (node == ((Way)object).firstNode() || node == ((Way)object).lastNode()) continue;
                arrayList.add(((Line)hashMap.get(object)).projectionCommand(node));
                continue;
            }
            if (arrayList2.size() == 2) {
                object = ((Line)hashMap.get(arrayList2.get(0))).intersectionCommand(node, (Line)hashMap.get(arrayList2.get(1)));
                if (object == null) {
                    this.showWarning(I18n.tr("Two parallels ways found. Abort.", new Object[0]));
                    return;
                }
                arrayList.add(object);
                continue;
            }
            this.showWarning(I18n.tr("Intersection of three or more ways can not be solved. Abort.", new Object[0]));
            return;
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Line", new Object[0]), arrayList));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AlignInLineAction.getCurrentDataSet() != null && !AlignInLineAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private class Line {
        private double a;
        private double b;
        private double c;
        private double xM;
        private double yM;

        public Line(Way way) {
            this.xM = way.firstNode().getEastNorth().getX();
            this.yM = way.firstNode().getEastNorth().getY();
            double d = way.lastNode().getEastNorth().getX();
            double d2 = way.lastNode().getEastNorth().getY();
            this.a = d2 - this.yM;
            this.b = this.xM - d;
            double d3 = Math.sqrt(this.a * this.a + this.b * this.b);
            if (d3 == 0.0) {
                d3 = 1.0;
            }
            this.a /= d3;
            this.b /= d3;
            this.c = -(this.a * this.xM + this.b * this.yM);
        }

        public Command projectionCommand(Node node) {
            double d = (this.xM - node.getEastNorth().getX()) * this.a + (this.yM - node.getEastNorth().getY()) * this.b;
            return new MoveCommand((OsmPrimitive)node, this.a * d, this.b * d);
        }

        public Command intersectionCommand(Node node, Line line) {
            double d = this.a * line.b - line.a * this.b;
            if (d == 0.0) {
                return null;
            }
            double d2 = (this.b * line.c - line.b * this.c) / d;
            double d3 = (line.a * this.c - this.a * line.c) / d;
            return new MoveCommand((OsmPrimitive)node, d2 - node.getEastNorth().getX(), d3 - node.getEastNorth().getY());
        }
    }
}

