/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AddNodeAction
extends JosmAction {
    private String textLatLon;
    private String textEastNorth;

    public AddNodeAction() {
        super(I18n.tr("Add Node...", new Object[0]), "addnode", I18n.tr("Add a node by entering latitude / longitude or easting / northing.", new Object[0]), Shortcut.registerShortcut("addnode", I18n.tr("Edit: {0}", I18n.tr("Add Node...", new Object[0])), 68, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/AddNode"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        LatLonDialog latLonDialog = new LatLonDialog(Main.parent, I18n.tr("Add Node...", new Object[0]), HelpUtil.ht("/Action/AddNode"));
        if (this.textLatLon != null) {
            latLonDialog.setLatLonText(this.textLatLon);
        }
        if (this.textEastNorth != null) {
            latLonDialog.setEastNorthText(this.textEastNorth);
        }
        latLonDialog.showDialog();
        if (latLonDialog.getValue() != 1) {
            return;
        }
        LatLon latLon = latLonDialog.getCoordinates();
        if (latLon == null) {
            return;
        }
        this.textLatLon = latLonDialog.getLatLonText();
        this.textEastNorth = latLonDialog.getEastNorthText();
        Node node = new Node(latLon);
        Main.main.undoRedo.add(new AddCommand(node));
        AddNodeAction.getCurrentDataSet().setSelected(node);
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AddNodeAction.getEditLayer() != null);
    }
}

