/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.app.beans;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import javax.swing.Icon;

public class SVGIcon
implements Icon {
    public static final long serialVersionUID = 1L;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    SVGUniverse svgUniverse = SVGCache.getSVGUniverse();
    public static final int INTERP_NEAREST_NEIGHBOR = 0;
    public static final int INTERP_BILINEAR = 1;
    public static final int INTERP_BICUBIC = 2;
    private boolean antiAlias;
    private int interpolation = 0;
    private boolean clipToViewbox;
    URI svgURI;
    private boolean scaleToFit;
    AffineTransform scaleXform = new AffineTransform();
    Dimension preferredSize;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public int getIconHeight() {
        if (this.scaleToFit && this.preferredSize != null) {
            return this.preferredSize.height;
        }
        SVGDiagram sVGDiagram = this.svgUniverse.getDiagram(this.svgURI);
        if (sVGDiagram == null) {
            return 0;
        }
        return (int)sVGDiagram.getHeight();
    }

    @Override
    public int getIconWidth() {
        if (this.scaleToFit && this.preferredSize != null) {
            return this.preferredSize.width;
        }
        SVGDiagram sVGDiagram = this.svgUniverse.getDiagram(this.svgURI);
        if (sVGDiagram == null) {
            return 0;
        }
        return (int)sVGDiagram.getWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.paintIcon(component, graphics2D, n, n2);
        graphics2D.dispose();
    }

    private void paintIcon(Component component, Graphics2D graphics2D, int n, int n2) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        switch (this.interpolation) {
            case 0: {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                break;
            }
            case 1: {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case 2: {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        SVGDiagram sVGDiagram = this.svgUniverse.getDiagram(this.svgURI);
        if (sVGDiagram == null) {
            return;
        }
        graphics2D.translate(n, n2);
        sVGDiagram.setIgnoringClipHeuristic(!this.clipToViewbox);
        if (this.clipToViewbox) {
            graphics2D.setClip(new Rectangle2D.Float(0.0f, 0.0f, sVGDiagram.getWidth(), sVGDiagram.getHeight()));
        }
        if (!this.scaleToFit) {
            try {
                sVGDiagram.render(graphics2D);
                graphics2D.translate(-n, -n2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return;
        }
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        if (n3 == 0 || n4 == 0) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        sVGDiagram.getViewRect(double_);
        this.scaleXform.setToScale((double)n3 / double_.width, (double)n4 / double_.height);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.scaleXform);
        try {
            sVGDiagram.render(graphics2D);
        }
        catch (SVGException sVGException) {
            throw new RuntimeException(sVGException);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.translate(-n, -n2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        if (object2 != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
        }
    }

    public SVGUniverse getSvgUniverse() {
        return this.svgUniverse;
    }

    public void setSvgUniverse(SVGUniverse sVGUniverse) {
        SVGUniverse sVGUniverse2 = this.svgUniverse;
        this.svgUniverse = sVGUniverse;
        this.changes.firePropertyChange("svgUniverse", sVGUniverse2, sVGUniverse);
    }

    public URI getSvgURI() {
        return this.svgURI;
    }

    public void setSvgURI(URI uRI) {
        URI uRI2 = this.svgURI;
        this.svgURI = uRI;
        SVGDiagram sVGDiagram = this.svgUniverse.getDiagram(uRI);
        if (sVGDiagram != null) {
            Dimension dimension = this.getPreferredSize();
            if (dimension == null) {
                dimension = new Dimension((int)sVGDiagram.getRoot().getDeviceWidth(), (int)sVGDiagram.getRoot().getDeviceHeight());
            }
            sVGDiagram.setDeviceViewport(new Rectangle(0, 0, dimension.width, dimension.height));
        }
        this.changes.firePropertyChange("svgURI", uRI2, uRI);
    }

    public void setSvgResourcePath(String string) {
        URI uRI = this.svgURI;
        try {
            this.svgURI = new URI(this.getClass().getResource(string).toString());
            this.changes.firePropertyChange("svgURI", uRI, this.svgURI);
            SVGDiagram sVGDiagram = this.svgUniverse.getDiagram(this.svgURI);
            if (sVGDiagram != null) {
                sVGDiagram.setDeviceViewport(new Rectangle(0, 0, this.preferredSize.width, this.preferredSize.height));
            }
        }
        catch (Exception exception) {
            this.svgURI = uRI;
        }
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setScaleToFit(boolean bl) {
        boolean bl2 = this.scaleToFit;
        this.scaleToFit = bl;
        this.changes.firePropertyChange("scaleToFit", bl2, bl);
    }

    public Dimension getPreferredSize() {
        SVGDiagram sVGDiagram;
        if (this.preferredSize == null && (sVGDiagram = this.svgUniverse.getDiagram(this.svgURI)) != null) {
            this.setPreferredSize(new Dimension((int)sVGDiagram.getWidth(), (int)sVGDiagram.getHeight()));
        }
        return new Dimension(this.preferredSize);
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension;
        SVGDiagram sVGDiagram = this.svgUniverse.getDiagram(this.svgURI);
        if (sVGDiagram != null) {
            sVGDiagram.setDeviceViewport(new Rectangle(0, 0, dimension.width, dimension.height));
        }
        this.changes.firePropertyChange("preferredSize", dimension2, dimension);
    }

    public boolean getUseAntiAlias() {
        return this.getAntiAlias();
    }

    public void setUseAntiAlias(boolean bl) {
        this.setAntiAlias(bl);
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        boolean bl2 = this.antiAlias;
        this.antiAlias = bl;
        this.changes.firePropertyChange("antiAlias", bl2, bl);
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(int n) {
        int n2 = this.interpolation;
        this.interpolation = n;
        this.changes.firePropertyChange("interpolation", n2, n);
    }

    public boolean isClipToViewbox() {
        return this.clipToViewbox;
    }

    public void setClipToViewbox(boolean bl) {
        this.clipToViewbox = bl;
    }
}

