/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.EclipseModuleManager;
import org.jetbrains.idea.eclipse.conversion.ConversionException;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;

public class EclipseClasspathWriter {
    private static final Logger LOG = Logger.getInstance((String)("#" + EclipseClasspathWriter.class.getName()));
    private final ModuleRootModel myModel;
    private final Map<String, Element> myOldEntries = new HashMap<String, Element>();

    public EclipseClasspathWriter(ModuleRootModel model) {
        this.myModel = model;
    }

    public void writeClasspath(Element classpathElement, @Nullable Element oldRoot) throws ConversionException {
        String url;
        OrderEntry orderEntry2;
        if (oldRoot != null) {
            for (Object o : oldRoot.getChildren("classpathentry")) {
                Element oldChild = (Element)o;
                String oldKind = oldChild.getAttributeValue("kind");
                String oldPath = oldChild.getAttributeValue("path");
                this.myOldEntries.put(oldKind + EclipseClasspathWriter.getJREKey(oldPath), oldChild);
            }
        }
        for (OrderEntry orderEntry2 : this.myModel.getOrderEntries()) {
            this.createClasspathEntry(orderEntry2, classpathElement);
        }
        String outputPath = "bin";
        VirtualFile contentRoot = EPathUtil.getContentRoot(this.myModel);
        VirtualFile output = ((CompilerModuleExtension)this.myModel.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputPath();
        if (contentRoot != null && output != null && VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)output, (boolean)false)) {
            outputPath = EPathUtil.collapse2EclipsePath(output.getUrl(), this.myModel);
        } else if (output == null && (url = ((CompilerModuleExtension)this.myModel.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl()) != null) {
            outputPath = EPathUtil.collapse2EclipsePath(url, this.myModel);
        }
        orderEntry2 = this.addOrderEntry("output", outputPath, classpathElement);
        EclipseClasspathWriter.setAttributeIfAbsent((Element)orderEntry2, "path", "bin");
    }

    private void createClasspathEntry(OrderEntry entry, Element classpathRoot) throws ConversionException {
        if (entry instanceof ModuleSourceOrderEntry) {
            ContentEntry[] entries;
            ModuleRootModel rootModel = ((ModuleSourceOrderEntry)entry).getRootModel();
            for (ContentEntry contentEntry : entries = rootModel.getContentEntries()) {
                VirtualFile contentRoot = contentEntry.getFile();
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    String linkedPath;
                    String relativePath = EPathUtil.collapse2EclipsePath(sourceFolder.getUrl(), this.myModel);
                    if (contentRoot != EPathUtil.getContentRoot(rootModel) && (linkedPath = EclipseModuleManager.getInstance(entry.getOwnerModule()).getEclipseLinkedSrcVariablePath(sourceFolder.getUrl())) != null) {
                        relativePath = linkedPath;
                    }
                    this.addOrderEntry("src", relativePath, classpathRoot);
                }
            }
        } else if (entry instanceof ModuleOrderEntry) {
            Element orderEntry = this.addOrderEntry("src", "/" + ((ModuleOrderEntry)entry).getModuleName(), classpathRoot);
            EclipseClasspathWriter.setAttributeIfAbsent(orderEntry, "combineaccessrules", "false");
            EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)entry);
        } else if (entry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            String libraryName = libraryOrderEntry.getLibraryName();
            EclipseModuleManager eclipseModuleManager = EclipseModuleManager.getInstance(libraryOrderEntry.getOwnerModule());
            if (libraryOrderEntry.isModuleLevel()) {
                String[] files = libraryOrderEntry.getRootUrls(OrderRootType.CLASSES);
                if (files.length > 0) {
                    if (libraryName != null && libraryName.contains("junit") && Comparing.strEqual((String)files[0], (String)EclipseClasspathReader.getJunitClsUrl(libraryName.contains("4")))) {
                        Element orderEntry = this.addOrderEntry("con", "org.eclipse.jdt.junit.JUNIT_CONTAINER/" + libraryName.substring("junit".length()), classpathRoot);
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    } else {
                        String srcRelativePath;
                        boolean newVarLibrary = false;
                        String eclipseVariablePath = eclipseModuleManager.getEclipseVariablePath(files[0]);
                        if (eclipseVariablePath == null && !eclipseModuleManager.isEclipseLibUrl(files[0])) {
                            newVarLibrary = true;
                            eclipseVariablePath = EPathUtil.collapse2EclipseVariabledPath(libraryOrderEntry, OrderRootType.CLASSES);
                        }
                        Element orderEntry = eclipseVariablePath != null ? this.addOrderEntry("var", eclipseVariablePath, classpathRoot) : this.addOrderEntry("lib", EPathUtil.collapse2EclipsePath(files[0], this.myModel), classpathRoot);
                        String eclipseSrcVariablePath = null;
                        boolean addSrcRoots = true;
                        String[] srcFiles = libraryOrderEntry.getRootUrls(OrderRootType.SOURCES);
                        if (srcFiles.length == 0) {
                            srcRelativePath = null;
                        } else {
                            String srcFile = srcFiles[0];
                            srcRelativePath = EPathUtil.collapse2EclipsePath(srcFile, this.myModel);
                            if (eclipseVariablePath != null && (eclipseSrcVariablePath = eclipseModuleManager.getEclipseSrcVariablePath(srcFile)) == null) {
                                eclipseSrcVariablePath = EPathUtil.collapse2EclipseVariabledPath(libraryOrderEntry, OrderRootType.SOURCES);
                                if (eclipseSrcVariablePath != null) {
                                    eclipseSrcVariablePath = "/" + eclipseSrcVariablePath;
                                } else if (newVarLibrary) {
                                    orderEntry.detach();
                                    orderEntry = this.addOrderEntry("lib", EPathUtil.collapse2EclipsePath(files[0], this.myModel), classpathRoot);
                                } else {
                                    LOG.info("Added root " + srcRelativePath + " (in existing var library) can't be replaced with any variable; src roots placed in .eml only");
                                    addSrcRoots = false;
                                }
                            }
                        }
                        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "sourcepath", addSrcRoots ? (eclipseSrcVariablePath != null ? eclipseSrcVariablePath : srcRelativePath) : null);
                        EJavadocUtil.setupJavadocAttributes(orderEntry, libraryOrderEntry, this.myModel);
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    }
                }
            } else {
                Element orderEntry = eclipseModuleManager.getUnknownCons().contains(libraryName) ? this.addOrderEntry("con", libraryName, classpathRoot) : (Comparing.strEqual((String)libraryName, (String)"ECLIPSE") ? this.addOrderEntry("con", "org.eclipse.pde.core.requiredPlugins", classpathRoot) : this.addOrderEntry("con", "org.eclipse.jdt.USER_LIBRARY/" + libraryName, classpathRoot));
                EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
            }
        } else if (entry instanceof JdkOrderEntry) {
            if (entry instanceof InheritedJdkOrderEntry) {
                if (!EclipseModuleManager.getInstance(entry.getOwnerModule()).isForceConfigureJDK()) {
                    this.addOrderEntry("con", "org.eclipse.jdt.launching.JRE_CONTAINER", classpathRoot);
                }
            } else {
                String jdkLink;
                Sdk jdk = ((JdkOrderEntry)entry).getJdk();
                if (jdk == null) {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                } else {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                    if (jdk.getSdkType() instanceof JavaSdkType) {
                        jdkLink = jdkLink + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
                    }
                    jdkLink = jdkLink + "/" + jdk.getName();
                }
                this.addOrderEntry("con", jdkLink, classpathRoot);
            }
        } else {
            throw new ConversionException("Unknown EclipseProjectModel.ClasspathEntry: " + entry.getClass());
        }
    }

    private Element addOrderEntry(String kind, String path, Element classpathRoot) {
        Element element = this.myOldEntries.get(kind + EclipseClasspathWriter.getJREKey(path));
        if (element != null) {
            Element clonedElement = (Element)element.clone();
            classpathRoot.addContent(clonedElement);
            return clonedElement;
        }
        Element orderEntry = new Element("classpathentry");
        orderEntry.setAttribute("kind", kind);
        if (path != null) {
            orderEntry.setAttribute("path", path);
        }
        classpathRoot.addContent(orderEntry);
        return orderEntry;
    }

    private static String getJREKey(String path) {
        return path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER") ? "org.eclipse.jdt.launching.JRE_CONTAINER" : path;
    }

    private static void setExported(Element orderEntry, ExportableOrderEntry dependency) {
        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "exported", dependency.isExported() ? "true" : null);
    }

    private static void setOrRemoveAttribute(Element element, String name, String value) {
        if (value != null) {
            element.setAttribute(name, value);
        } else {
            element.removeAttribute(name);
        }
    }

    private static void setAttributeIfAbsent(Element element, String name, String value) {
        if (element.getAttribute(name) == null) {
            element.setAttribute(name, value);
        }
    }
}

