/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class VariableUsedInArrayInitializerVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean passed;

    public VariableUsedInArrayInitializerVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableUsedInArrayInitializerVisitor.<init> must not be null");
        }
        this.passed = false;
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableUsedInArrayInitializerVisitor.visitElement must not be null");
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] args;
        if (this.passed) {
            return;
        }
        super.visitArrayInitializerExpression(expression);
        for (PsiExpression arg : args = expression.getInitializers()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) continue;
            this.passed = true;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

