/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/BoolUtils.isNegation must not be null");
        }
        if (!(expression instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        PsiJavaToken sign = prefixExp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    @Nullable
    private static PsiExpression getNegated(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/BoolUtils.getNegated must not be null");
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        PsiExpression operand = prefixExp.getOperand();
        return ParenthesesUtils.stripParentheses(operand);
    }

    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        if (condition == null) {
            return "";
        }
        if (condition instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
            PsiExpression contentExpression = parenthesizedExpression.getExpression();
            return '(' + BoolUtils.getNegatedExpressionText(contentExpression) + ')';
        }
        if (BoolUtils.isNegation(condition)) {
            PsiExpression negated = BoolUtils.getNegated(condition);
            if (negated == null) {
                return "";
            }
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > 3) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }

    public static boolean isTrue(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        String text = expression.getText();
        return "true".equals(text);
    }

    public static boolean isFalse(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        String text = expression.getText();
        return "false".equals(text);
    }
}

