/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class StringToStringInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("RedundantStringToString" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringToStringInspection.getID must not return null");
        }
        return "RedundantStringToString";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.to.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringToStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.to.string.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringToStringInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringToStringVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringToStringFix();
    }

    private static class StringToStringVisitor
    extends BaseInspectionVisitor {
        private StringToStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringToStringInspection$StringToStringVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class StringToStringFix
    extends InspectionGadgetsFix {
        private StringToStringFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringToStringInspection$StringToStringFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression call = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression expression = call.getMethodExpression();
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            StringToStringFix.replaceExpression((PsiExpression)call, qualifierText);
        }
    }
}

