/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class BadExceptionThrownInspection
extends BaseInspection {
    public String exceptionsString = "java.lang.Throwable,java.lang.Exception,java.lang.Error,java.lang.RuntimeException,java.lang.NullPointerException,java.lang.ClassCastException,java.lang.ArrayIndexOutOfBoundsException";
    final List<String> exceptionList = new ArrayList<String>(32);

    public BadExceptionThrownInspection() {
        BadExceptionThrownInspection.parseString(this.exceptionsString, this.exceptionList);
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        BadExceptionThrownInspection.parseString(this.exceptionsString, this.exceptionList);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.exceptionsString = BadExceptionThrownInspection.formatString(this.exceptionList);
        super.writeSettings(element);
    }

    @NotNull
    public String getID() {
        if ("ProhibitedExceptionThrown" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionThrownInspection.getID must not return null");
        }
        return "ProhibitedExceptionThrown";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.exception.thrown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionThrownInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String exceptionName = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("bad.exception.thrown.problem.descriptor", exceptionName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionThrownInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionThrownVisitor();
    }

    private class Form {
        JPanel contentPanel;
        JButton addButton;
        JButton removeButton;
        IGTable table;

        Form() {
            this.$$$setupUI$$$();
            this.addButton.setAction(new AddAction(this.table));
            this.removeButton.setAction(new RemoveAction(this.table));
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(BadExceptionThrownInspection.this.exceptionList, InspectionGadgetsBundle.message("exception.class.column.name", new Object[0])));
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 3, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            this.addButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.add"));
            jButton2.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            this.removeButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.remove"));
            jButton.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class BadExceptionThrownVisitor
    extends BaseInspectionVisitor {
        private final Set<String> exceptionSet;

        private BadExceptionThrownVisitor() {
            this.exceptionSet = new HashSet<String>(BadExceptionThrownInspection.this.exceptionList);
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type == null) {
                return;
            }
            String text = type.getCanonicalText();
            if (this.exceptionSet.contains(text)) {
                this.registerStatementError((PsiStatement)statement, type);
            }
        }
    }
}

