/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLabelOnContinueStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.label.on.continue.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryLabelOnContinueStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.label.on.continue.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryLabelOnContinueStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryLabelOnContinueStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLabelOnContinueStatementVisitor();
    }

    private static class UnnecessaryLabelOnContinueStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLabelOnContinueStatementVisitor() {
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/UnnecessaryLabelOnContinueStatementInspection$UnnecessaryLabelOnContinueStatementVisitor.visitContinueStatement must not be null");
            }
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            String labelText = labelIdentifier.getText();
            if (labelText == null || labelText.length() == 0) {
                return;
            }
            PsiStatement exitedStatement = statement.findContinuedStatement();
            if (exitedStatement == null) {
                return;
            }
            PsiStatement labelEnabledParent = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiForStatement.class, PsiDoWhileStatement.class, PsiForeachStatement.class, PsiWhileStatement.class, PsiSwitchStatement.class});
            if (labelEnabledParent == null) {
                return;
            }
            if (!exitedStatement.equals(labelEnabledParent)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }

    private static class UnnecessaryLabelOnContinueStatementFix
    extends InspectionGadgetsFix {
        private UnnecessaryLabelOnContinueStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.label.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryLabelOnContinueStatementInspection$UnnecessaryLabelOnContinueStatementFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor.getPsiElement();
            PsiContinueStatement continueStatement = (PsiContinueStatement)continueKeywordElement.getParent();
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            labelIdentifier.delete();
        }
    }
}

