/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class SuspiciousSystemArraycopyInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.system.arraycopy.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousSystemArraycopyVisitor();
    }

    private static class SuspiciousSystemArraycopyVisitor
    extends BaseInspectionVisitor {
        private SuspiciousSystemArraycopyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpression dest;
            PsiType destType;
            PsiExpression length;
            PsiExpression destPos;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection$SuspiciousSystemArraycopyVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"arraycopy".equals(name)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String canonicalText = referenceExpression.getCanonicalText();
            if (!canonicalText.equals("java.lang.System")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 5) {
                return;
            }
            PsiExpression src = arguments[0];
            PsiType srcType = src.getType();
            PsiExpression srcPos = arguments[1];
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(srcPos)) {
                String errorString = InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor1", new Object[0]);
                this.registerError((PsiElement)srcPos, errorString);
            }
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(destPos = arguments[3])) {
                String errorString = InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor2", new Object[0]);
                this.registerError((PsiElement)destPos, errorString);
            }
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(length = arguments[4])) {
                String errorString = InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor3", new Object[0]);
                this.registerError((PsiElement)length, errorString);
            }
            boolean notArrayReported = false;
            if (!(srcType instanceof PsiArrayType)) {
                String errorString = InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor4", new Object[0]);
                this.registerError((PsiElement)src, errorString);
                notArrayReported = true;
            }
            if (!((destType = (dest = arguments[2]).getType()) instanceof PsiArrayType)) {
                String errorString = InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor5", new Object[0]);
                this.registerError((PsiElement)dest, errorString);
                notArrayReported = true;
            }
            if (notArrayReported) {
                return;
            }
            PsiArrayType srcArrayType = (PsiArrayType)srcType;
            PsiArrayType destArrayType = (PsiArrayType)destType;
            PsiType srcComponentType = srcArrayType.getComponentType();
            PsiType destComponentType = destArrayType.getComponentType();
            if (!(srcComponentType instanceof PsiPrimitiveType)) {
                if (!destComponentType.isAssignableFrom(srcComponentType)) {
                    String errorString = InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText());
                    this.registerError((PsiElement)dest, errorString);
                }
            } else if (!destComponentType.equals(srcComponentType)) {
                String errorString = InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText());
                this.registerError((PsiElement)dest, errorString);
            }
        }

        private static boolean isNegativeArgument(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection$SuspiciousSystemArraycopyVisitor.isNegativeArgument must not be null");
            }
            Object constant = ExpressionUtils.computeConstantExpression(argument);
            if (!(constant instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)constant;
            return integer < 0;
        }
    }
}

