/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ResultOfObjectAllocationIgnoredInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.object.allocation.ignored.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ResultOfObjectAllocationIgnoredInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("result.of.object.allocation.ignored.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ResultOfObjectAllocationIgnoredInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private static class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ResultOfObjectAllocationIgnoredInspection$IgnoreResultOfCallVisitor.visitExpressionStatement must not be null");
            }
            super.visitExpressionStatement(statement);
            PsiExpression expression = statement.getExpression();
            if (!(expression instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
            if (arrayDimensions.length != 0) {
                return;
            }
            if (newExpression.getArrayInitializer() != null) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }
    }
}

