/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.ParameterClassCheckVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsWhichDoesntCheckParameterClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.doesnt.check.class.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.doesnt.check.class.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsWhichDoesntCheckParameterClassVisitor();
    }

    private static class EqualsWhichDoesntCheckParameterClassVisitor
    extends BaseInspectionVisitor {
        private EqualsWhichDoesntCheckParameterClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection$EqualsWhichDoesntCheckParameterClassVisitor.visitMethod must not be null");
            }
            if (!MethodUtils.isEquals(method)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[0];
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (EqualsWhichDoesntCheckParameterClassVisitor.isParameterChecked(body, parameter)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isParameterChecked(PsiCodeBlock body, PsiParameter parameter) {
            if (EqualsWhichDoesntCheckParameterClassVisitor.usesEqualsBuilderReflectionEquals(body)) {
                return true;
            }
            ParameterClassCheckVisitor visitor = new ParameterClassCheckVisitor(parameter);
            body.accept((PsiElementVisitor)visitor);
            return visitor.isChecked();
        }

        private static boolean usesEqualsBuilderReflectionEquals(PsiCodeBlock body) {
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return false;
            }
            PsiStatement statement = statements[0];
            if (!(statement instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (!(returnValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)returnValue;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"reflectionEquals".equals(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiClass aClass = (PsiClass)target;
            String className = aClass.getQualifiedName();
            return "org.apache.commons.lang.builder.EqualsBuilder".equals(className);
        }
    }
}

