/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class PublicMethodNotExposedInInterfaceInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.method.not.in.interface.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.method.not.in.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodNotExposedInInterface();
    }

    private static class PublicMethodNotExposedInInterface
    extends BaseInspectionVisitor {
        private PublicMethodNotExposedInInterface() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspection$PublicMethodNotExposedInInterface.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!containingClass.hasModifierProperty("public")) {
                return;
            }
            if (PublicMethodNotExposedInInterface.exposedInInterface(method)) {
                return;
            }
            if (TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean exposedInInterface(PsiMethod method) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass.isInterface()) {
                    return true;
                }
                String superclassName = superClass.getQualifiedName();
                if ("java.lang.Object".equals(superclassName)) {
                    return true;
                }
                if (!PublicMethodNotExposedInInterface.exposedInInterface(superMethod)) continue;
                return true;
            }
            return false;
        }
    }
}

