/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.ReflectionCache;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.MonitoringComponentAdapterFactory;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class IdeaPicoContainer
extends DefaultPicoContainer {
    public IdeaPicoContainer() {
        this(null);
    }

    public IdeaPicoContainer(PicoContainer parent) {
        super((ComponentAdapterFactory)new MyComponentAdapterFactory(), parent);
    }

    @Override
    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return super.getComponentAdapterOfType(componentType);
    }

    @Override
    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        if (componentType == String.class) {
            return Collections.emptyList();
        }
        ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
        Map<String, ComponentAdapter> cache = this.getAssignablesCache();
        ComponentAdapter cacheHit = cache.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        for (ComponentAdapter o : this.getNonAssignableAdapters()) {
            ComponentAdapter componentAdapter = o;
            if (componentAdapter instanceof AssignableToComponentAdapter) {
                AssignableToComponentAdapter assignableToComponentAdapter = (AssignableToComponentAdapter)componentAdapter;
                if (!assignableToComponentAdapter.isAssignableTo(componentType)) continue;
                result.add(assignableToComponentAdapter);
                continue;
            }
            if (!ReflectionCache.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            result.add(componentAdapter);
        }
        return result;
    }

    private static class MyComponentAdapterFactory
    extends MonitoringComponentAdapterFactory {
        private final LifecycleStrategy myLifecycleStrategy = new DefaultLifecycleStrategy((ComponentMonitor)new DefaultComponentMonitor());

        private MyComponentAdapterFactory() {
        }

        public ComponentAdapter createComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
            if (componentKey == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/pico/IdeaPicoContainer$MyComponentAdapterFactory.createComponentAdapter must not be null");
            }
            if (componentImplementation == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/pico/IdeaPicoContainer$MyComponentAdapterFactory.createComponentAdapter must not be null");
            }
            return new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters, true, this.currentMonitor(), this.myLifecycleStrategy));
        }

        public void changeMonitor(ComponentMonitor monitor) {
            super.changeMonitor(monitor);
            if (this.myLifecycleStrategy instanceof ComponentMonitorStrategy) {
                ((ComponentMonitorStrategy)this.myLifecycleStrategy).changeMonitor(monitor);
            }
        }
    }
}

