/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ResizeableMappedFile;
import java.io.IOException;
import java.io.InputStream;

public class MappedFileInputStream
extends InputStream {
    private ResizeableMappedFile raf;
    private int cur;
    private long limit;

    public MappedFileInputStream(ResizeableMappedFile raf, long pos, long limit) {
        this.raf = raf;
        this.setup(pos, limit);
    }

    public void setup(long pos, long limit) {
        this.cur = (int)pos;
        this.limit = limit;
    }

    public MappedFileInputStream(ResizeableMappedFile raf, long pos) throws IOException {
        this(raf, pos, raf.length());
    }

    @Override
    public int available() {
        return (int)(this.limit - (long)this.cur);
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        int retval = -1;
        if ((long)this.cur < this.limit) {
            retval = this.raf.get(this.cur++);
        }
        return retval;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (length > this.available()) {
            length = this.available();
        }
        if (this.available() > 0) {
            this.raf.get(this.cur, b, offset, length);
            this.cur += length;
        }
        return length;
    }

    @Override
    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.cur = (int)((long)this.cur + amountSkipped);
        return amountSkipped;
    }
}

