/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class UniqueResultsQuery<T, M>
implements Query<T> {
    private final Query<T> myOriginal;
    private final TObjectHashingStrategy<M> myHashingStrategy;
    private final Function<T, M> myMapper;
    public static final Function ID = new Function(){

        public Object fun(Object o) {
            return o;
        }
    };

    public UniqueResultsQuery(Query<T> original) {
        this(original, TObjectHashingStrategy.CANONICAL, ID);
    }

    public UniqueResultsQuery(Query<T> original, TObjectHashingStrategy<M> hashingStrategy) {
        this(original, hashingStrategy, ID);
    }

    public UniqueResultsQuery(Query<T> original, TObjectHashingStrategy<M> hashingStrategy, Function<T, M> mapper) {
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    @Override
    public boolean forEach(final @NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.forEach must not be null");
        }
        final ConcurrentHashSet<M> processedElements = new ConcurrentHashSet<M>(this.myHashingStrategy);
        return this.myOriginal.forEach(new Processor<T>(){

            @Override
            public boolean process(T t) {
                return !processedElements.add(UniqueResultsQuery.this.myMapper.fun(t)) || consumer.process(t);
            }
        });
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.forEach((Processor<T>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/UniqueResultsQuery.findAll must not return null");
        }
        return collection;
    }

    @Override
    public T[] toArray(T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

