/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;

public class Word {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.Word");
    private final String myText;
    private final TextRange myRange;

    public Word(String text, TextRange range) {
        this.myText = text;
        this.myRange = range;
        LOG.assertTrue(this.myRange.getStartOffset() >= 0);
        LOG.assertTrue(this.myRange.getEndOffset() >= this.myRange.getStartOffset(), this.myRange);
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Word)) {
            return false;
        }
        Word other = (Word)obj;
        return this.getText().equals(other.getText());
    }

    public String getText() {
        return this.myRange.substring(this.myText);
    }

    public String getPrefix(int fromPosition) {
        LOG.assertTrue(fromPosition >= 0, "" + fromPosition);
        int wordStart = this.myRange.getStartOffset();
        LOG.assertTrue(fromPosition <= wordStart, "" + fromPosition + " " + wordStart);
        return this.myText.substring(fromPosition, wordStart);
    }

    public int getEnd() {
        return this.myRange.getEndOffset();
    }

    public int getStart() {
        return this.myRange.getStartOffset();
    }

    public String toString() {
        return this.getText();
    }

    public boolean isWhitespace() {
        return false;
    }

    public boolean atEndOfLine() {
        int start = this.myRange.getStartOffset();
        if (start == 0) {
            return true;
        }
        if (this.myText.charAt(start - 1) == '\n') {
            return true;
        }
        int end = this.myRange.getEndOffset();
        if (end == this.myText.length()) {
            return true;
        }
        return this.myText.charAt(end) == '\n';
    }
}

