/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandlerListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitLineHandler
extends GitHandler {
    private final StringBuilder myStdoutLine;
    private final StringBuilder myStderrLine;
    private final EventDispatcher<GitLineHandlerListener> myLineListeners;

    public GitLineHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitLineHandler.<init> must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/commands/GitLineHandler.<init> must not be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/commands/GitLineHandler.<init> must not be null");
        }
        super(project, directory, command);
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitLineHandler.<init> must not be null");
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/commands/GitLineHandler.<init> must not be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/commands/GitLineHandler.<init> must not be null");
        }
        super(project, vcsRoot, command);
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    }

    @Override
    protected void processTerminated(int exitCode) {
        if (!this.isStdoutSuppressed() && this.myStdoutLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDOUT);
        } else if (!this.isStderrSuppressed() && this.myStderrLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDERR);
        }
    }

    public void addLineListener(GitLineHandlerListener listener) {
        super.addListener(listener);
        this.myLineListeners.addListener((EventListener)listener);
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        Iterator<String> lines = GitLineHandler.splitText(text).iterator();
        if (ProcessOutputTypes.STDOUT == outputType) {
            this.notifyLines(outputType, lines, this.myStdoutLine);
        } else if (ProcessOutputTypes.STDERR == outputType) {
            this.notifyLines(outputType, lines, this.myStderrLine);
        }
    }

    private void notifyLines(Key outputType, Iterator<String> lines, StringBuilder lineBuilder) {
        block4: {
            String line;
            if (!lines.hasNext()) {
                return;
            }
            if (lineBuilder.length() > 0) {
                lineBuilder.append(lines.next());
                if (lines.hasNext()) {
                    line = lineBuilder.toString();
                    this.notifyLine(line, outputType);
                    lineBuilder.setLength(0);
                }
            }
            while (true) {
                line = lines.next();
                if (!lines.hasNext()) break;
                this.notifyLine(line, outputType);
            }
            if (line.length() <= 0) break block4;
            lineBuilder.append(line);
        }
    }

    private void notifyLine(String line, Key outputType) {
        String trimmed = GitLineHandler.trimLineSeparator(line);
        if (this.myVcs != null && !"\r".equals(line.substring(trimmed.length()))) {
            if (outputType == ProcessOutputTypes.STDOUT && !this.isStdoutSuppressed()) {
                this.myVcs.showMessages(trimmed);
            } else if (outputType == ProcessOutputTypes.STDERR && !this.isStderrSuppressed()) {
                this.myVcs.showErrorMessages(trimmed);
            }
        }
        ((GitLineHandlerListener)this.myLineListeners.getMulticaster()).onLineAvailable(trimmed, outputType);
    }

    private static String trimLineSeparator(String line) {
        char ch2;
        int n = line.length();
        if (n == 0) {
            return line;
        }
        char ch = line.charAt(n - 1);
        if (ch != '\n' && ch != '\r') {
            return line;
        }
        if (--n > 0 && ((ch2 = line.charAt(n - 1)) == '\n' || ch2 == '\r') && ch2 != ch) {
            --n;
        }
        return line.substring(0, n);
    }

    private static List<String> splitText(String text) {
        int startLine = 0;
        int i = 0;
        int n = text.length();
        ArrayList<String> rc = new ArrayList<String>();
        block4: while (i < n) {
            switch (text.charAt(i)) {
                case '\n': {
                    if (++i < n && text.charAt(i) == '\r') {
                        ++i;
                    }
                    rc.add(text.substring(startLine, i));
                    startLine = i;
                    continue block4;
                }
                case '\r': {
                    if (++i < n && text.charAt(i) == '\n') {
                        ++i;
                    }
                    rc.add(text.substring(startLine, i));
                    startLine = i;
                    continue block4;
                }
            }
            ++i;
        }
        rc.add(text.substring(startLine, i));
        return rc;
    }
}

