/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GitFileUtils {
    public static final int FILE_PATH_LIMIT = 7600;

    private GitFileUtils() {
    }

    public static List<List<String>> chunkRelativePaths(List<String> files) {
        int i;
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start = 0;
        int size = 0;
        for (i = 0; i < files.size(); ++i) {
            String p = files.get(i);
            if (size + p.length() > 7600) {
                if (start == i) {
                    rc.add(files.subList(i, i + 1));
                    start = i + 1;
                } else {
                    rc.add(files.subList(start, i));
                    start = i;
                }
                size = 0;
                continue;
            }
            size += p.length();
        }
        if (start != files.size()) {
            rc.add(files.subList(start, i));
        }
        return rc;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<FilePath> files) {
        return GitFileUtils.chunkRelativePaths(GitUtil.toRelativePaths(root, files));
    }

    public static List<List<String>> chunkFiles(VirtualFile root, Collection<VirtualFile> files) {
        return GitFileUtils.chunkRelativePaths(GitUtil.toRelativeFiles(root, files));
    }

    public static void delete(Project project, VirtualFile root, Collection<FilePath> files, String ... additionalOptions) throws VcsException {
        for (List<String> paths : GitFileUtils.chunkPaths(root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RM);
            handler.addParameters(additionalOptions);
            handler.endOptions();
            handler.addParameters(paths);
            handler.setNoSSH(true);
            handler.run();
        }
    }

    public static void deleteFiles(Project project, VirtualFile root, List<VirtualFile> files) throws VcsException {
        for (List<String> paths : GitFileUtils.chunkFiles(root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RM);
            handler.endOptions();
            handler.addParameters(paths);
            handler.setNoSSH(true);
            handler.run();
        }
    }

    public static void deleteFiles(Project project, VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files));
    }

    public static void addFiles(Project project, VirtualFile root, Collection<VirtualFile> files) throws VcsException {
        for (List<String> paths : GitFileUtils.chunkFiles(root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.ADD);
            handler.endOptions();
            handler.addParameters(paths);
            handler.setNoSSH(true);
            handler.run();
        }
    }

    public static void addFiles(Project project, VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(Project project, VirtualFile root, Collection<FilePath> files) throws VcsException {
        for (List<String> paths : GitFileUtils.chunkPaths(root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.ADD);
            handler.endOptions();
            handler.addParameters(paths);
            handler.setNoSSH(true);
            handler.run();
        }
    }
}

