/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ComparatorDelegate;
import com.intellij.util.containers.Convertor;
import git4idea.GitRevisionNumber;
import git4idea.GitRevisionSelector;
import git4idea.GitRootConverter;
import git4idea.GitUtil;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.changes.GitChangeProvider;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.changes.GitOutgoingChangesProvider;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVcsConfigurable;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.diff.GitDiffProvider;
import git4idea.diff.GitTreeDiffProvider;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeProvider;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.update.GitUpdateEnvironment;
import git4idea.vfs.GitConfigListener;
import git4idea.vfs.GitConfigTracker;
import git4idea.vfs.GitIgnoreTracker;
import git4idea.vfs.GitRootTracker;
import git4idea.vfs.GitRootsListener;
import git4idea.vfs.GitVFSListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcs
extends AbstractVcs {
    private static final Logger log = Logger.getInstance((String)GitVcs.class.getName());
    @NonNls
    public static final String NAME = "Git";
    private static final VcsKey ourKey = GitVcs.createKey((String)"Git");
    private final ChangeProvider myChangeProvider;
    private final CheckinEnvironment myCheckinEnvironment;
    private final RollbackEnvironment myRollbackEnvironment;
    private final GitUpdateEnvironment myUpdateEnvironment;
    private final GitAnnotationProvider myAnnotationProvider;
    private final DiffProvider myDiffProvider;
    private final VcsHistoryProvider myHistoryProvider;
    private final ProjectLevelVcsManager myVcsManager;
    private final GitVcsSettings mySettings;
    private final Configurable myConfigurable;
    private final RevisionSelector myRevSelector;
    private final GitMergeProvider myMergeProvider;
    private GitVFSListener myVFSListener;
    private GitVersion myVersion;
    private final Object myCheckingVersion;
    private String myVersionCheckExcecutable;
    private GitCommittedChangeListProvider myCommittedChangeListProvider;
    private GitRootTracker myRootTracker;
    private final EventDispatcher<GitRootsListener> myRootListeners;
    private final EventDispatcher<GitConfigListener> myConfigListeners;
    private GitIgnoreTracker myGitIgnoreTracker;
    private GitConfigTracker myConfigTracker;
    private final BackgroundTaskQueue myTaskQueue;
    private final ReadWriteLock myCommandLock;
    private final TreeDiffProvider myTreeDiffProvider;
    private GitCommitAndPushExecutor myCommitAndPushExecutor;
    private final GitOutgoingChangesProvider myOutgoingChangesProvider;

    public static GitVcs getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitVcs.getInstance must not be null");
        }
        return (GitVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
    }

    public GitVcs(@NotNull Project project, @NotNull GitChangeProvider gitChangeProvider, @NotNull GitCheckinEnvironment gitCheckinEnvironment, @NotNull ProjectLevelVcsManager gitVcsManager, @NotNull GitAnnotationProvider gitAnnotationProvider, @NotNull GitDiffProvider gitDiffProvider, @NotNull GitHistoryProvider gitHistoryProvider, @NotNull GitRollbackEnvironment gitRollbackEnvironment, @NotNull GitVcsSettings gitSettings) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitChangeProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitCheckinEnvironment == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitVcsManager == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitAnnotationProvider == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitDiffProvider == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitHistoryProvider == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitRollbackEnvironment == null) {
            throw new IllegalArgumentException("Argument 7 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        if (gitSettings == null) {
            throw new IllegalArgumentException("Argument 8 for @NotNull parameter of git4idea/GitVcs.<init> must not be null");
        }
        super(project, NAME);
        this.myCheckingVersion = new Object();
        this.myVersionCheckExcecutable = "";
        this.myRootListeners = EventDispatcher.create(GitRootsListener.class);
        this.myConfigListeners = EventDispatcher.create(GitConfigListener.class);
        this.myCommandLock = new ReentrantReadWriteLock(true);
        this.myVcsManager = gitVcsManager;
        this.mySettings = gitSettings;
        this.myChangeProvider = gitChangeProvider;
        this.myCheckinEnvironment = gitCheckinEnvironment;
        this.myAnnotationProvider = gitAnnotationProvider;
        this.myDiffProvider = gitDiffProvider;
        this.myHistoryProvider = gitHistoryProvider;
        this.myRollbackEnvironment = gitRollbackEnvironment;
        this.myRevSelector = new GitRevisionSelector();
        this.myConfigurable = new GitVcsConfigurable(this.mySettings, this.myProject);
        this.myUpdateEnvironment = new GitUpdateEnvironment(this.myProject, this, this.mySettings);
        this.myMergeProvider = new GitMergeProvider(this.myProject);
        this.myCommittedChangeListProvider = new GitCommittedChangeListProvider(this.myProject);
        this.myOutgoingChangesProvider = new GitOutgoingChangesProvider(this.myProject);
        this.myTreeDiffProvider = new GitTreeDiffProvider(this.myProject);
        this.myCommitAndPushExecutor = new GitCommitAndPushExecutor(gitCheckinEnvironment);
        this.myTaskQueue = new BackgroundTaskQueue(this.myProject, GitBundle.getString("task.queue.title"));
    }

    public ReadWriteLock getCommandLock() {
        return this.myCommandLock;
    }

    public void runInBackground(Task.Backgroundable task) {
        this.myTaskQueue.run(task);
    }

    public void addGitConfigListener(GitConfigListener listener) {
        this.myConfigListeners.addListener((EventListener)listener);
    }

    public void removeGitConfigListener(GitConfigListener listener) {
        this.myConfigListeners.removeListener((EventListener)listener);
    }

    public void addGitRootsListener(GitRootsListener listener) {
        this.myRootListeners.addListener((EventListener)listener);
    }

    public void removeGitRootsListener(GitRootsListener listener) {
        this.myRootListeners.removeListener((EventListener)listener);
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return null;
    }

    public String getRevisionPattern() {
        return "[0-9a-fA-F]{40}";
    }

    @NotNull
    public CheckinEnvironment getCheckinEnvironment() {
        CheckinEnvironment checkinEnvironment = this.myCheckinEnvironment;
        if (checkinEnvironment == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getCheckinEnvironment must not return null");
        }
        return checkinEnvironment;
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        GitMergeProvider gitMergeProvider = this.myMergeProvider;
        if (gitMergeProvider == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getMergeProvider must not return null");
        }
        return gitMergeProvider;
    }

    @NotNull
    public RollbackEnvironment getRollbackEnvironment() {
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getRollbackEnvironment must not return null");
        }
        return rollbackEnvironment;
    }

    @NotNull
    public VcsHistoryProvider getVcsHistoryProvider() {
        VcsHistoryProvider vcsHistoryProvider = this.myHistoryProvider;
        if (vcsHistoryProvider == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getVcsHistoryProvider must not return null");
        }
        return vcsHistoryProvider;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.myHistoryProvider;
    }

    @NotNull
    public String getDisplayName() {
        if (NAME == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getDisplayName must not return null");
        }
        return NAME;
    }

    @Nullable
    public UpdateEnvironment getUpdateEnvironment() {
        return this.myUpdateEnvironment;
    }

    @NotNull
    public GitAnnotationProvider getAnnotationProvider() {
        GitAnnotationProvider gitAnnotationProvider = this.myAnnotationProvider;
        if (gitAnnotationProvider == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getAnnotationProvider must not return null");
        }
        return gitAnnotationProvider;
    }

    @NotNull
    public DiffProvider getDiffProvider() {
        DiffProvider diffProvider = this.myDiffProvider;
        if (diffProvider == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getDiffProvider must not return null");
        }
        return diffProvider;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return this.myRevSelector;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revision, FilePath path) {
        if (revision == null || revision.length() == 0) {
            return null;
        }
        if (revision.length() > 40) {
            String dateString = revision.substring(0, revision.indexOf("["));
            String rev = revision.substring(revision.indexOf("[") + 1, 40);
            Date d = new Date(Date.parse(dateString));
            return new GitRevisionNumber(rev, d);
        }
        if (path != null) {
            try {
                VirtualFile root = GitUtil.getGitRoot(path);
                return GitRevisionNumber.resolve(this.myProject, root, revision);
            }
            catch (VcsException e) {
                log.error("Unexpected problem with resolving the git revision number: ", (Throwable)e);
            }
        }
        return new GitRevisionNumber(revision);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revision) {
        return this.parseRevisionNumber(revision, null);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return dir.isDirectory() && GitUtil.gitRootOrNull(dir) != null;
    }

    protected void start() throws VcsException {
    }

    protected void shutdown() throws VcsException {
    }

    protected void activate() {
        if (!this.myProject.isDefault() && this.myRootTracker == null) {
            this.myRootTracker = new GitRootTracker(this, this.myProject, (GitRootsListener)this.myRootListeners.getMulticaster());
        }
        if (this.myVFSListener == null) {
            this.myVFSListener = new GitVFSListener(this.myProject, this);
        }
        if (this.myConfigTracker == null) {
            this.myConfigTracker = new GitConfigTracker(this.myProject, this, (GitConfigListener)this.myConfigListeners.getMulticaster());
        }
        if (this.myGitIgnoreTracker == null) {
            this.myGitIgnoreTracker = new GitIgnoreTracker(this.myProject, this);
        }
    }

    protected void deactivate() {
        if (this.myRootTracker != null) {
            this.myRootTracker.dispose();
            this.myRootTracker = null;
        }
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        if (this.myGitIgnoreTracker != null) {
            this.myGitIgnoreTracker.dispose();
            this.myGitIgnoreTracker = null;
        }
        if (this.myConfigTracker != null) {
            this.myConfigTracker.dispose();
            this.myConfigTracker = null;
        }
    }

    @NotNull
    public synchronized Configurable getConfigurable() {
        Configurable configurable = this.myConfigurable;
        if (configurable == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getConfigurable must not return null");
        }
        return configurable;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return this.myChangeProvider;
    }

    public void showErrors(@NotNull List<VcsException> list, @NotNull String action) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitVcs.showErrors must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitVcs.showErrors must not be null");
        }
        if (list.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\n");
            buffer.append(GitBundle.message("error.list.title", action));
            for (VcsException exception : list) {
                buffer.append("\n");
                buffer.append(exception.getMessage());
            }
            String msg = buffer.toString();
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)GitBundle.getString("error.dialog.title"));
        }
    }

    public void showMessages(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitVcs.showMessages must not be null");
        }
        if (message.length() == 0) {
            return;
        }
        this.showMessage(message, ConsoleViewContentType.NORMAL_OUTPUT.getAttributes());
    }

    @NotNull
    public GitVcsSettings getSettings() {
        GitVcsSettings gitVcsSettings = this.mySettings;
        if (gitVcsSettings == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitVcs.getSettings must not return null");
        }
        return gitVcsSettings;
    }

    private void showMessage(@NotNull String message, TextAttributes style) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitVcs.showMessage must not be null");
        }
        this.myVcsManager.addMessageToConsoleWindow(message, style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkVersion() {
        String executable = this.mySettings.getGitExecutable();
        Object object = this.myCheckingVersion;
        synchronized (object) {
            String version;
            if (this.myVersion != null && this.myVersionCheckExcecutable.equals(executable)) {
                return;
            }
            this.myVersionCheckExcecutable = executable;
            this.myVersion = GitVersion.INVALID;
            try {
                version = GitVcs.version(this.myProject).trim();
            }
            catch (VcsException e) {
                String reason = (e.getCause() != null ? e.getCause() : e).getMessage();
                if (!this.myProject.isDefault()) {
                    this.showMessage(GitBundle.message("vcs.unable.to.run.git", executable, reason), ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes());
                }
                return;
            }
            this.myVersion = GitVersion.parse(version);
            if (!GitVersion.parse(version).isSupported() && !this.myProject.isDefault()) {
                this.showMessage(GitBundle.message("vcs.unsupported.version", version, GitVersion.MIN), ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes());
            }
        }
    }

    public GitVersion version() {
        this.checkVersion();
        return this.myVersion;
    }

    public static String version(Project project) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, new File("."), GitCommand.VERSION);
        h.setNoSSH(true);
        h.setSilent(true);
        String s = h.run();
        return s;
    }

    public void showCommandLine(String cmdLine) {
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss.SSS");
        this.showMessage(f.format(new Date()) + ": " + cmdLine, ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes());
    }

    public void showErrorMessages(String line) {
        this.showMessage(line, ConsoleViewContentType.ERROR_OUTPUT.getAttributes());
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        Collections.sort(in, new ComparatorDelegate(convertor, (Comparator)FilePathComparator.getInstance()));
        block0: for (int i = 1; i < in.size(); ++i) {
            S sChild = in.get(i);
            VirtualFile child = (VirtualFile)convertor.convert(sChild);
            VirtualFile childRoot = GitUtil.gitRootOrNull(child);
            if (childRoot == null) continue;
            for (int j = i - 1; j >= 0; --j) {
                S sParent = in.get(j);
                VirtualFile parent = (VirtualFile)convertor.convert(sParent);
                if (!VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false) || !VfsUtil.isAncestor((VirtualFile)childRoot, (VirtualFile)parent, (boolean)false)) continue;
                in.remove(i);
                --i;
                continue block0;
            }
        }
        return in;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return GitRootConverter.INSTANCE;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distibuted;
    }

    protected VcsOutgoingChangesProvider getOutgoingProviderImpl() {
        return this.myOutgoingChangesProvider;
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    protected TreeDiffProvider getTreeDiffProviderImpl() {
        return this.myTreeDiffProvider;
    }

    public List<CommitExecutor> getCommitExecutors() {
        return Collections.singletonList(this.myCommitAndPushExecutor);
    }

    public CommittedChangeList getRevisionChanges(VcsFileRevision revision, VirtualFile file) throws VcsException {
        Project project = this.getProject();
        VirtualFile vcsRoot = GitUtil.getGitRoot(file);
        return GitChangeUtils.getRevisionChanges(project, vcsRoot, revision.getRevisionNumber().asString());
    }
}

