/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitReference;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitTag
extends GitReference {
    @NonNls
    public static final String REFS_TAGS_PREFIX = "refs/tags/";

    public GitTag(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitTag.<init> must not be null");
        }
        super(name);
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = REFS_TAGS_PREFIX + this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitTag.getFullName must not return null");
        }
        return string;
    }

    public static void listAsStrings(Project project, VirtualFile root, Collection<String> tags) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.TAG);
        handler.setNoSSH(true);
        handler.setSilent(true);
        handler.addParameters("-l");
        for (String line : handler.run().split("\n")) {
            if (line.length() == 0) continue;
            tags.add(line);
        }
    }

    public static void list(Project project, VirtualFile root, Collection<? super GitTag> tags) throws VcsException {
        ArrayList<String> temp = new ArrayList<String>();
        GitTag.listAsStrings(project, root, temp);
        for (String t : temp) {
            tags.add(new GitTag(t));
        }
    }
}

