/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeFormComponentTypeFix
implements IntentionAction {
    private final PsiPlainTextFile myFormFile;
    private final String myFieldName;
    private final PsiType myComponentTypeToSet;

    public ChangeFormComponentTypeFix(PsiPlainTextFile formFile, String fieldName, PsiType componentTypeToSet) {
        this.myFormFile = formFile;
        this.myFieldName = fieldName;
        this.myComponentTypeToSet = componentTypeToSet;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"uidesigner.change.gui.component.type", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix.invoke must not be null");
        }
        CommandProcessor.getInstance().executeCommand(file.getProject(), new Runnable(){

            @Override
            public void run() {
                ReadonlyStatusHandler readOnlyHandler = ReadonlyStatusHandler.getInstance((Project)ChangeFormComponentTypeFix.this.myFormFile.getProject());
                ReadonlyStatusHandler.OperationStatus status = readOnlyHandler.ensureFilesWritable(new VirtualFile[]{ChangeFormComponentTypeFix.this.myFormFile.getVirtualFile()});
                if (!status.hasReadonlyFiles()) {
                    FormReferenceProvider.setGUIComponentType(ChangeFormComponentTypeFix.this.myFormFile, ChangeFormComponentTypeFix.this.myFieldName, ChangeFormComponentTypeFix.this.myComponentTypeToSet);
                }
            }
        }, this.getText(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

