/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.util.PairProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AreaMap<Key extends Comparable<Key>, Val> {
    private final List<Key> myKeys;
    private final Map<Key, Val> myMap;
    private final PairProcessor<Key, Key> myKeysResemblance;

    public AreaMap(PairProcessor<Key, Key> keysResemblance) {
        this.myKeysResemblance = keysResemblance;
        this.myKeys = new LinkedList<Key>();
        this.myMap = new HashMap<Key, Val>();
    }

    public void put(Key key, Val val) {
        this.myMap.put(key, val);
        if (this.myKeys.isEmpty()) {
            this.myKeys.add(key);
            return;
        }
        int idx = Collections.binarySearch(this.myKeys, key);
        if (idx < 0) {
            int insertionIdx = -idx - 1;
            this.myKeys.add(insertionIdx, key);
        }
    }

    @Nullable
    public Val getExact(Key key) {
        return this.myMap.get(key);
    }

    public void getSimiliar(Key key, PairProcessor<Key, Val> consumer) {
        int idx = Collections.binarySearch(this.myKeys, key);
        if (idx < 0) {
            int insertionIdx = -idx - 1;
            int itemBeforeIdx = insertionIdx - 1;
            if (itemBeforeIdx >= 0) {
                Comparable candidate;
                for (int i = itemBeforeIdx; i >= 0 && this.myKeysResemblance.process((Object)(candidate = (Comparable)this.myKeys.get(i)), key) && !consumer.process((Object)candidate, this.myMap.get(candidate)); --i) {
                }
            }
        } else {
            consumer.process(key, this.myMap.get(key));
        }
    }
}

