/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnAuthenticationManager;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.dialogs.SvnInteractiveAuthenticationProvider;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnAuthenticationNotifier
extends GenericNotifierImpl<AuthenticationRequest, SVNURL> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnAuthenticationNotifier");
    private static final String ourGroupId = "SubversionId";
    private final SvnVcs myVcs;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final Map<SVNURL, Boolean> myCopiesPassiveResults;
    private Timer myTimer;

    public SvnAuthenticationNotifier(SvnVcs svnVcs) {
        super(svnVcs.getProject(), ourGroupId, "Not Logged In to Subversion", NotificationType.ERROR);
        this.myVcs = svnVcs;
        this.myRootsToWorkingCopies = this.myVcs.getRootsToWorkingCopies();
        this.myCopiesPassiveResults = Collections.synchronizedMap(new HashMap());
    }

    public void init() {
        if (this.myTimer != null) {
            this.stop();
        }
        this.myTimer = new Timer("SVN authentication timer");
        this.myTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SvnAuthenticationNotifier.this.myCopiesPassiveResults.clear();
            }
        }, 10000L, 600000L);
    }

    public void stop() {
        this.myTimer.cancel();
        this.myTimer = null;
    }

    protected boolean ask(final AuthenticationRequest obj) {
        final Ref resultRef = new Ref();
        boolean done = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                boolean result = SvnAuthenticationNotifier.interactiveValidation(obj.myProject, obj.getUrl(), obj.getRealm(), obj.getKind());
                SvnAuthenticationNotifier.log("ask result for: " + obj.getUrl() + " is: " + result);
                resultRef.set((Object)result);
                if (result) {
                    SvnAuthenticationNotifier.this.onStateChangedToSuccess(obj);
                }
            }
        }, "Checking authorization state", true, this.myVcs.getProject());
        return done && Boolean.TRUE.equals(resultRef.get());
    }

    private void onStateChangedToSuccess(AuthenticationRequest obj) {
        this.myVcs.invokeRefreshSvnRoots(false);
        this.myCopiesPassiveResults.put(this.getKey(obj), true);
        final LinkedList<SVNURL> outdatedRequests = new LinkedList<SVNURL>();
        Collection keys = this.getAllCurrentKeys();
        for (SVNURL key : keys) {
            SVNURL commonURLAncestor = SVNURLUtil.getCommonURLAncestor((SVNURL)key, (SVNURL)obj.getUrl());
            if (commonURLAncestor == null || StringUtil.isEmptyOrSpaces((String)commonURLAncestor.getHost()) || StringUtil.isEmptyOrSpaces((String)commonURLAncestor.getPath())) continue;
            outdatedRequests.add(key);
        }
        SvnAuthenticationNotifier.log("on state changed ");
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                for (SVNURL key : outdatedRequests) {
                    SvnAuthenticationNotifier.this.removeLazyNotificationByKey(key);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    public void ensureNotify(AuthenticationRequest obj) {
        SVNURL key = this.getKey(obj);
        this.myCopiesPassiveResults.remove(key);
        super.ensureNotify((Object)obj);
    }

    @NotNull
    public SVNURL getKey(AuthenticationRequest obj) {
        SVNURL sVNURL = obj.getWcUrl();
        if (sVNURL == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnAuthenticationNotifier.getKey must not return null");
        }
        return sVNURL;
    }

    @Nullable
    public SVNURL getWcUrl(AuthenticationRequest obj) {
        if (obj.isOutsideCopies()) {
            return null;
        }
        if (obj.getWcUrl() != null) {
            return obj.getWcUrl();
        }
        WorkingCopy copy = this.myRootsToWorkingCopies.getMatchingCopy(obj.getUrl());
        if (copy != null) {
            obj.setOutsideCopies(false);
            obj.setWcUrl(copy.getUrl());
        } else {
            obj.setOutsideCopies(true);
        }
        return copy == null ? null : copy.getUrl();
    }

    public ThreeState isAuthenticatedFor(VirtualFile vf) {
        WorkingCopy wcCopy = this.myRootsToWorkingCopies.getWcRoot(vf);
        if (wcCopy == null) {
            return ThreeState.UNSURE;
        }
        boolean haveCancellation = this.getStateFor(wcCopy.getUrl());
        if (haveCancellation) {
            return ThreeState.NO;
        }
        Boolean keptResult = this.myCopiesPassiveResults.get(wcCopy.getUrl());
        if (Boolean.TRUE.equals(keptResult)) {
            return ThreeState.YES;
        }
        if (Boolean.FALSE.equals(keptResult)) {
            return ThreeState.NO;
        }
        boolean calculatedResult = SvnAuthenticationNotifier.passiveValidation(this.myVcs.getProject(), wcCopy.getUrl());
        this.myCopiesPassiveResults.put(wcCopy.getUrl(), calculatedResult);
        return calculatedResult ? ThreeState.YES : ThreeState.NO;
    }

    @NotNull
    protected String getNotificationContent(AuthenticationRequest obj) {
        String string = "<a href=\"\">Click to fix.</a> Not logged In to Subversion '" + obj.getRealm() + "' (" + obj.getUrl().toDecodedString() + ")";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnAuthenticationNotifier.getNotificationContent must not return null");
        }
        return string;
    }

    @NotNull
    protected String getToString(AuthenticationRequest obj) {
        String string = "Click to fix. Not logged In to Subversion '" + obj.getRealm() + "' (" + obj.getUrl().toDecodedString() + ")";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnAuthenticationNotifier.getToString must not return null");
        }
        return string;
    }

    static void log(Throwable t) {
        LOG.debug(t);
    }

    static void log(String s) {
        LOG.debug(s);
    }

    public static boolean passiveValidation(Project project, SVNURL url) {
        SvnConfiguration configuration = SvnConfiguration.getInstance(project);
        SvnAuthenticationManager passiveManager = configuration.getPassiveAuthenticationManager();
        return SvnAuthenticationNotifier.validationImpl(project, url, configuration, passiveManager, false, null, null);
    }

    public static boolean interactiveValidation(Project project, SVNURL url, String realm, String kind) {
        SvnConfiguration configuration = SvnConfiguration.getInstance(project);
        SvnAuthenticationManager passiveManager = configuration.getInteractiveManager(SvnVcs.getInstance(project));
        return SvnAuthenticationNotifier.validationImpl(project, url, configuration, passiveManager, true, realm, kind);
    }

    private static boolean validationImpl(Project project, SVNURL url, SvnConfiguration configuration, SvnAuthenticationManager manager, boolean checkWrite, String realm, String kind) {
        SvnInteractiveAuthenticationProvider.clearCallState();
        try {
            new SVNWCClient((ISVNAuthenticationManager)manager, configuration.getOptions(project)).doInfo(url, SVNRevision.UNDEFINED, SVNRevision.HEAD);
        }
        catch (SVNAuthenticationException e) {
            SvnAuthenticationNotifier.log(e);
            return false;
        }
        catch (SVNCancelException e) {
            SvnAuthenticationNotifier.log(e);
            return false;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode().isAuthentication()) {
                SvnAuthenticationNotifier.log(e);
                return false;
            }
            LOG.info("some other exc", (Throwable)e);
        }
        if (!checkWrite) {
            return true;
        }
        if (SvnInteractiveAuthenticationProvider.wasCalled() && SvnInteractiveAuthenticationProvider.wasCancelled()) {
            return false;
        }
        if (SvnInteractiveAuthenticationProvider.wasCalled()) {
            return true;
        }
        SvnVcs svnVcs = SvnVcs.getInstance(project);
        SvnInteractiveAuthenticationProvider provider = new SvnInteractiveAuthenticationProvider(svnVcs, manager);
        SVNAuthentication svnAuthentication = provider.requestClientAuthentication(kind, url, realm, null, null, true);
        if (svnAuthentication != null) {
            configuration.acknowledge(kind, realm, svnAuthentication);
            return true;
        }
        return false;
    }

    public static class AuthenticationRequest {
        private final Project myProject;
        private final String myKind;
        private final SVNURL myUrl;
        private final String myRealm;
        private SVNURL myWcUrl;
        private boolean myOutsideCopies;

        public AuthenticationRequest(Project project, String kind, SVNURL url, String realm) {
            this.myProject = project;
            this.myKind = kind;
            this.myUrl = url;
            this.myRealm = realm;
        }

        public boolean isOutsideCopies() {
            return this.myOutsideCopies;
        }

        public void setOutsideCopies(boolean outsideCopies) {
            this.myOutsideCopies = outsideCopies;
        }

        public SVNURL getWcUrl() {
            return this.myWcUrl;
        }

        public void setWcUrl(SVNURL wcUrl) {
            this.myWcUrl = wcUrl;
        }

        public String getKind() {
            return this.myKind;
        }

        public SVNURL getUrl() {
            return this.myUrl;
        }

        public String getRealm() {
            return this.myRealm;
        }
    }
}

