/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BasicXmlAttributeDescriptor
implements XmlAttributeDescriptor {
    public String validateValue(XmlElement context, String value) {
        String defaultValue;
        if (this.isFixed() && (defaultValue = this.getDefaultValue()) != null && !defaultValue.equals(value)) {
            return XmlErrorMessages.message("attribute.should.have.fixed.value", this.getName(), defaultValue);
        }
        if (this.isEnumerated(context) && XmlUtil.isSimpleXmlAttributeValue(value, (XmlAttributeValue)context)) {
            String[] values = this.getEnumeratedValues(context);
            boolean valueWasFound = false;
            for (String enumValue : values) {
                if (!enumValue.equals(value)) continue;
                valueWasFound = true;
                break;
            }
            if (!valueWasFound) {
                return XmlErrorMessages.message("wrong.attribute.value", new Object[0]);
            }
        }
        return null;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @Nullable
    public String[] getEnumeratedValues(@Nullable XmlElement context) {
        return this.getEnumeratedValues();
    }

    public boolean isEnumerated(@Nullable XmlElement context) {
        return this.isEnumerated();
    }
}

