/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ConcurrentClassMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NonNls;

public class VisitorDescription {
    private final Class<? extends DomElementVisitor> myVisitorClass;
    private final ConcurrentClassMap<Method> myMethods = new ConcurrentClassMap();
    @NonNls
    private static final String VISIT = "visit";

    public VisitorDescription(Class<? extends DomElementVisitor> visitorClass) {
        this.myVisitorClass = visitorClass;
        for (Method method : ReflectionCache.getMethods(visitorClass)) {
            String methodName;
            Class<?> domClass;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !ReflectionCache.isAssignable(DomElement.class, domClass = parameterTypes[0]) || !VISIT.equals(methodName = method.getName()) && (!methodName.startsWith(VISIT) || !domClass.getSimpleName().equals(methodName.substring(VISIT.length())))) continue;
            method.setAccessible(true);
            this.myMethods.put(domClass, (Object)method);
        }
    }

    public void acceptElement(DomElementVisitor visitor, DomElement element) {
        Method method = (Method)this.myMethods.get(element.getClass());
        assert (method != null) : this.myVisitorClass + " can't accept element of type " + element.getClass();
        DomReflectionUtil.invokeMethod((Method)method, (Object)visitor, (Object[])new Object[]{element});
    }
}

