/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedRootsProvider;
import gnu.trove.THashSet;
import java.util.Set;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    private final Set<VirtualFile> myRoots = new THashSet();

    public AdditionalIndexableFileSet() {
        this((IndexedRootsProvider[])Extensions.getExtensions(IndexedRootsProvider.EP_NAME));
    }

    public AdditionalIndexableFileSet(IndexedRootsProvider ... extensions) {
        for (IndexedRootsProvider provider : extensions) {
            for (String url : provider.getRootsToIndex()) {
                ContainerUtil.addIfNotNull((Object)VirtualFileManager.getInstance().findFileByUrl(url), this.myRoots);
            }
        }
    }

    @Override
    public boolean isInSet(VirtualFile file) {
        for (VirtualFile root : this.myRoots) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void iterateIndexableFilesIn(VirtualFile file, ContentIterator iterator) {
        if (!this.isInSet(file)) {
            return;
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                this.iterateIndexableFilesIn(child, iterator);
            }
        } else {
            iterator.processFile(file);
        }
    }
}

