/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.Language;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class UsageViewUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageViewUtil");

    private UsageViewUtil() {
    }

    public static String createNodeText(PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
    }

    public static String getMetaDataName(PsiMetaData metaData) {
        String name = metaData.getName();
        return StringUtil.isEmpty((String)name) ? "''" : name;
    }

    public static String getShortName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid());
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
    }

    public static String getLongName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid());
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
    }

    public static String getType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageViewUtil.getType must not be null");
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }

    public static String getDescriptiveName(@NotNull PsiElement psiElement) {
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageViewUtil.getDescriptiveName must not be null");
        }
        LOG.assertTrue(psiElement.isValid());
        if (psiElement instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)psiElement).getMetaData()) != null) {
            return UsageViewUtil.getMetaDataName(metaData);
        }
        Language lang = psiElement.getLanguage();
        FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(lang);
        return provider.getDescriptiveName(psiElement);
    }

    public static boolean hasNonCodeUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (!usage.isNonCodeUsage) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadOnlyUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (usage.isWritable()) continue;
            return true;
        }
        return false;
    }

    public static UsageInfo[] removeDuplicatedUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageViewUtil.removeDuplicatedUsages must not be null");
        }
        LinkedHashSet<UsageInfo> set = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
        String newTextInNonCodeUsage = null;
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            newTextInNonCodeUsage = ((NonCodeUsageInfo)usage).newText;
            break;
        }
        if (newTextInNonCodeUsage != null) {
            for (UsageInfo usage : usages) {
                PsiReference psiReference;
                PsiElement usageElement;
                PsiElement context;
                PsiFile file;
                if (!(usage instanceof MoveRenameUsageInfo) || (file = usage.getFile()) == null || (context = file.getContext()) == null || (usageElement = usage.getElement()) == null || (psiReference = usage.getReference()) == null) continue;
                int injectionOffsetInMasterFile = PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)usageElement) + usageElement.getTextOffset();
                set.remove(NonCodeUsageInfo.create((PsiFile)context.getContainingFile(), (int)(usage.startOffset + injectionOffsetInMasterFile), (int)(usage.endOffset + injectionOffsetInMasterFile), (PsiElement)((MoveRenameUsageInfo)usage).getReferencedElement(), (String)newTextInNonCodeUsage));
            }
        }
        return set.toArray(new UsageInfo[set.size()]);
    }
}

