/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.AbstractToolTipHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public final class TreeToolTipHandler
extends AbstractToolTipHandler<Integer, JTree> {
    protected TreeToolTipHandler(JTree tree) {
        super(tree);
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    TreeToolTipHandler.this.repaintHint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void install(JTree tree) {
        new TreeToolTipHandler(tree);
    }

    @Override
    protected Integer getCellKeyForPoint(Point point) {
        int rowIndex = ((JTree)this.myComponent).getRowForLocation(point.x, point.y);
        return rowIndex != -1 ? new Integer(rowIndex) : null;
    }

    @Override
    protected Rectangle getCellBounds(Integer key, Component rendererComponent) {
        int rowIndex = key;
        TreePath path = ((JTree)this.myComponent).getPathForRow(rowIndex);
        Rectangle cellBounds = ((JTree)this.myComponent).getPathBounds(path);
        return cellBounds;
    }

    @Override
    protected Component getRendererComponent(Integer key) {
        Component rComponent;
        int rowIndex = key;
        TreeCellRenderer renderer = ((JTree)this.myComponent).getCellRenderer();
        if (renderer == null) {
            rComponent = null;
        } else {
            TreePath path = ((JTree)this.myComponent).getPathForRow(rowIndex);
            if (path == null) {
                rComponent = null;
            } else {
                Object node = path.getLastPathComponent();
                rComponent = renderer.getTreeCellRendererComponent((JTree)this.myComponent, node, ((JTree)this.myComponent).isRowSelected(rowIndex), ((JTree)this.myComponent).isExpanded(rowIndex), ((JTree)this.myComponent).getModel().isLeaf(node), rowIndex, ((JTree)this.myComponent).hasFocus());
            }
        }
        return rComponent;
    }
}

