/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurences;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurences.OccurenceFilter;
import com.intellij.refactoring.util.occurences.OccurenceManager;
import java.util.ArrayList;

public abstract class BaseOccurenceManager
implements OccurenceManager {
    private PsiExpression[] myOccurences = null;
    private PsiElement myAnchorStatement = null;
    protected final OccurenceFilter myFilter;

    public BaseOccurenceManager(OccurenceFilter filter) {
        this.myFilter = filter;
    }

    @Override
    public PsiExpression[] getOccurences() {
        if (this.myOccurences == null) {
            this.myOccurences = this.findOccurences();
            if (this.myFilter != null) {
                ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
                for (PsiExpression occurence : this.myOccurences) {
                    if (!this.myFilter.isOK(occurence)) continue;
                    result.add(occurence);
                }
                this.myOccurences = result.isEmpty() ? this.defaultOccurences() : result.toArray(new PsiExpression[result.size()]);
            }
            if (this.getAnchorStatementForAll() == null) {
                this.myOccurences = this.defaultOccurences();
            }
        }
        return this.myOccurences;
    }

    protected abstract PsiExpression[] defaultOccurences();

    protected abstract PsiExpression[] findOccurences();

    @Override
    public boolean isInFinalContext() {
        return BaseOccurenceManager.needToDeclareFinal(this.myOccurences);
    }

    @Override
    public PsiElement getAnchorStatementForAll() {
        if (this.myAnchorStatement == null) {
            this.myAnchorStatement = this.getAnchorStatementForAllInScope(null);
        }
        return this.myAnchorStatement;
    }

    @Override
    public PsiElement getAnchorStatementForAllInScope(PsiElement scope) {
        return RefactoringUtil.getAnchorElementForMultipleExpressions(this.myOccurences, scope);
    }

    private static boolean needToDeclareFinal(PsiExpression[] occurrences) {
        Object scopeToDeclare = null;
        for (PsiExpression occurrence : occurrences) {
            PsiElement data = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
            scopeToDeclare = scopeToDeclare == null ? (data != null ? data : occurrence) : PsiTreeUtil.findCommonParent((PsiElement)scopeToDeclare, (PsiElement)(data != null ? data : occurrence));
        }
        if (scopeToDeclare == null) {
            return false;
        }
        for (PsiExpression occurrence : occurrences) {
            PsiElement parent = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
            if (parent == null) {
                parent = occurrence;
            }
            while (!parent.equals(scopeToDeclare)) {
                if (!((parent = parent.getParent()) instanceof PsiClass)) continue;
                return true;
            }
        }
        return false;
    }
}

