/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.duplicates.ExpressionReturnValue;
import com.intellij.refactoring.util.duplicates.FieldReturnValue;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Match {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.duplicates.Match");
    private final PsiElement myMatchStart;
    private final PsiElement myMatchEnd;
    private final Map<PsiVariable, List<PsiElement>> myParameterValues = new HashMap();
    private final Map<PsiVariable, ArrayList<PsiElement>> myParameterOccurences = new HashMap();
    private final Map<PsiElement, PsiElement> myDeclarationCorrespondence = new HashMap();
    private ReturnValue myReturnValue = null;
    private Ref<PsiExpression> myInstanceExpression = null;
    private final Map<PsiVariable, PsiType> myChangedParams = new HashMap();

    Match(PsiElement start, PsiElement end) {
        LOG.assertTrue(start.getParent() == end.getParent());
        this.myMatchStart = start;
        this.myMatchEnd = end;
    }

    public PsiElement getMatchStart() {
        return this.myMatchStart;
    }

    public PsiElement getMatchEnd() {
        return this.myMatchEnd;
    }

    public List<PsiElement> getParameterValues(PsiVariable parameter) {
        return this.myParameterValues.get(parameter);
    }

    public ReturnValue getOutputVariableValue(PsiVariable outputParameter) {
        PsiElement decl = this.myDeclarationCorrespondence.get(outputParameter);
        if (decl instanceof PsiVariable) {
            return new VariableReturnValue((PsiVariable)decl);
        }
        List<PsiElement> parameterValue = this.getParameterValues(outputParameter);
        if (parameterValue != null && parameterValue.size() == 1 && parameterValue.get(0) instanceof PsiExpression) {
            return new ExpressionReturnValue((PsiExpression)parameterValue.get(0));
        }
        return null;
    }

    boolean putParameter(Pair<PsiVariable, PsiType> parameter, PsiElement value) {
        boolean isVararg;
        PsiVariable psiVariable = (PsiVariable)parameter.first;
        if (this.myDeclarationCorrespondence.get(psiVariable) == null) {
            final boolean[] valueDependsOnReplacedScope = new boolean[1];
            value.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    PsiElement resolved = expression.resolve();
                    if (resolved != null && Comparing.equal((Object)resolved.getContainingFile(), (Object)Match.this.getMatchEnd().getContainingFile())) {
                        TextRange range = resolved.getTextRange();
                        if (Match.this.getMatchStart().getTextOffset() <= range.getStartOffset() && range.getEndOffset() <= Match.this.getMatchEnd().getTextRange().getEndOffset()) {
                            valueDependsOnReplacedScope[0] = true;
                        }
                    }
                }
            });
            if (valueDependsOnReplacedScope[0]) {
                return false;
            }
        }
        List<PsiElement> currentValue = this.myParameterValues.get(psiVariable);
        boolean bl = isVararg = psiVariable instanceof PsiParameter && ((PsiParameter)psiVariable).isVarArgs();
        if (!(value instanceof PsiExpression)) {
            return false;
        }
        PsiType type = ((PsiExpression)value).getType();
        PsiType parameterType = (PsiType)parameter.second;
        if (type == null) {
            return false;
        }
        if (currentValue == null) {
            if (parameterType instanceof PsiClassType && ((PsiClassType)parameterType).resolve() instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)((PsiClassType)parameterType).resolve();
                LOG.assertTrue(typeParameter != null);
                for (PsiClassType classType : typeParameter.getExtendsListTypes()) {
                    if (classType.isAssignableFrom(type)) continue;
                    return false;
                }
            } else if (isVararg) {
                if (!((PsiEllipsisType)psiVariable.getType()).getComponentType().isAssignableFrom(type) && !((PsiEllipsisType)psiVariable.getType()).toArrayType().equals(type)) {
                    this.myChangedParams.put(psiVariable, (PsiType)new PsiEllipsisType(parameterType));
                }
            } else if (!parameterType.isAssignableFrom(type)) {
                return false;
            }
            ArrayList<PsiElement> values = new ArrayList<PsiElement>();
            values.add(value);
            this.myParameterValues.put(psiVariable, values);
            ArrayList elements = new ArrayList();
            this.myParameterOccurences.put(psiVariable, elements);
            return true;
        }
        for (PsiElement val : currentValue) {
            if (isVararg || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)val, (PsiElement)value)) continue;
            return false;
        }
        if (isVararg) {
            if (!parameterType.isAssignableFrom(type)) {
                return false;
            }
            currentValue.add(value);
        }
        this.myParameterOccurences.get(psiVariable).add(value);
        return true;
    }

    public ReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    boolean registerReturnValue(ReturnValue returnValue) {
        if (this.myReturnValue == null) {
            this.myReturnValue = returnValue;
            return true;
        }
        return this.myReturnValue.isEquivalent(returnValue);
    }

    boolean registerInstanceExpression(PsiExpression instanceExpression, PsiClass contextClass) {
        if (this.myInstanceExpression == null) {
            if (instanceExpression != null) {
                PsiType type = instanceExpression.getType();
                if (!(type instanceof PsiClassType)) {
                    return false;
                }
                PsiClass hisClass = ((PsiClassType)type).resolve();
                if (hisClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)hisClass, (PsiClass)contextClass, (boolean)true)) {
                    return false;
                }
            }
            this.myInstanceExpression = Ref.create((Object)instanceExpression);
            return true;
        }
        if (this.myInstanceExpression.get() == null) {
            this.myInstanceExpression.set((Object)instanceExpression);
            return instanceExpression == null;
        }
        if (instanceExpression != null) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)instanceExpression, (PsiElement)((PsiElement)this.myInstanceExpression.get()));
        }
        return this.myInstanceExpression.get() == null || this.myInstanceExpression.get() instanceof PsiThisExpression;
    }

    boolean putDeclarationCorrespondence(PsiElement patternDeclaration, @NotNull PsiElement matchDeclaration) {
        if (matchDeclaration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/duplicates/Match.putDeclarationCorrespondence must not be null");
        }
        PsiElement originalValue = this.myDeclarationCorrespondence.get(patternDeclaration);
        if (originalValue == null) {
            this.myDeclarationCorrespondence.put(patternDeclaration, matchDeclaration);
            return true;
        }
        return originalValue == matchDeclaration;
    }

    private PsiElement replaceWith(PsiStatement statement) throws IncorrectOperationException {
        PsiElement matchStart = this.getMatchStart();
        PsiElement matchEnd = this.getMatchEnd();
        PsiElement element = matchStart.getParent().addBefore((PsiElement)statement, matchStart);
        matchStart.getParent().deleteChildRange(matchStart, matchEnd);
        return element;
    }

    public PsiElement replaceByStatement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression, PsiVariable outputVariable) throws IncorrectOperationException {
        PsiStatement statement = null;
        if (outputVariable != null) {
            ReturnValue returnValue = this.getOutputVariableValue(outputVariable);
            if (returnValue == null && outputVariable instanceof PsiField) {
                returnValue = new FieldReturnValue((PsiField)outputVariable);
            }
            if (returnValue == null) {
                return null;
            }
            statement = returnValue.createReplacement(extractedMethod, methodCallExpression);
        } else if (this.getReturnValue() != null) {
            statement = this.getReturnValue().createReplacement(extractedMethod, methodCallExpression);
        }
        if (statement == null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)elementFactory.createStatementFromText("x();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((PsiManager)methodCallExpression.getManager());
            expressionStatement = (PsiExpressionStatement)styleManager.reformat((PsiElement)expressionStatement);
            expressionStatement.getExpression().replace((PsiElement)methodCallExpression);
            statement = expressionStatement;
        }
        return this.replaceWith(statement);
    }

    public PsiExpression getInstanceExpression() {
        if (this.myInstanceExpression == null) {
            return null;
        }
        return (PsiExpression)this.myInstanceExpression.get();
    }

    public PsiElement replace(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression, PsiVariable outputVariable) throws IncorrectOperationException {
        this.declareLocalVariables();
        if (this.getMatchStart() == this.getMatchEnd() && this.getMatchStart() instanceof PsiExpression) {
            return this.replaceWithExpression(methodCallExpression);
        }
        return this.replaceByStatement(extractedMethod, methodCallExpression, outputVariable);
    }

    private void declareLocalVariables() throws IncorrectOperationException {
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(this.getMatchStart());
        try {
            Project project = this.getMatchStart().getProject();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment));
            int endOffset = controlFlow.getEndOffset(this.getMatchEnd());
            int startOffset = controlFlow.getStartOffset(this.getMatchStart());
            List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(controlFlow, endOffset, controlFlow.getSize());
            Collection<ControlFlowUtil.VariableInfo> reassigned = ControlFlowUtil.getInitializedTwice(controlFlow, endOffset, controlFlow.getSize());
            Collection<PsiVariable> outVariables = ControlFlowUtil.getWrittenVariables(controlFlow, startOffset, endOffset, false);
            for (PsiVariable variable : usedVariables) {
                PsiIdentifier identifier;
                if (outVariables.contains(variable) || (identifier = variable.getNameIdentifier()) == null || identifier.getTextRange().getStartOffset() < this.getMatchStart().getTextRange().getStartOffset() || identifier.getTextRange().getEndOffset() > this.getMatchEnd().getTextRange().getEndOffset()) continue;
                String name = variable.getName();
                LOG.assertTrue(name != null);
                PsiDeclarationStatement statement = JavaPsiFacade.getInstance((Project)project).getElementFactory().createVariableDeclarationStatement(name, variable.getType(), null);
                if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                    PsiElement[] psiElements = statement.getDeclaredElements();
                    PsiModifierList modifierList = ((PsiVariable)psiElements[0]).getModifierList();
                    LOG.assertTrue(modifierList != null);
                    modifierList.setModifierProperty("final", false);
                }
                this.getMatchStart().getParent().addBefore((PsiElement)statement, this.getMatchStart());
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    private PsiElement replaceWithExpression(PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiElement matchStart = this.getMatchStart();
        LOG.assertTrue(matchStart == this.getMatchEnd());
        if (matchStart instanceof PsiReferenceExpression && matchStart.getParent() instanceof PsiMethodCallExpression) {
            return matchStart.replace((PsiElement)methodCallExpression.getMethodExpression());
        }
        return matchStart.replace((PsiElement)methodCallExpression);
    }

    TextRange getTextRange() {
        return new TextRange(this.getMatchStart().getTextRange().getStartOffset(), this.getMatchEnd().getTextRange().getEndOffset());
    }

    @Nullable
    public String getChangedSignature(PsiMethod method, boolean shouldBeStatic, @Modifier String visibility) {
        PsiType returnType = this.getChangedReturnType(method);
        if (!this.myChangedParams.isEmpty() || returnType != null) {
            PsiTypeParameterList typeParameterList;
            StringBuilder buffer = new StringBuilder();
            buffer.append(visibility);
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            if (shouldBeStatic) {
                buffer.append("static ");
            }
            if ((typeParameterList = method.getTypeParameterList()) != null) {
                buffer.append(typeParameterList.getText());
                buffer.append(" ");
            }
            buffer.append(PsiFormatUtil.formatType((PsiType)(returnType != null ? returnType : method.getReturnType()), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(" ");
            buffer.append(method.getName());
            buffer.append("(");
            int count = 0;
            String INDENT = "    ";
            ArrayList<ParameterInfoImpl> params = this.patchParams(method);
            for (ParameterInfoImpl param : params) {
                String typeText = param.getTypeText();
                if (count > 0) {
                    buffer.append(",");
                }
                buffer.append("\n");
                buffer.append("    ");
                buffer.append(typeText);
                buffer.append(" ");
                buffer.append(param.getName());
                ++count;
            }
            if (count > 0) {
                buffer.append("\n");
            }
            buffer.append(")");
            PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
            if (exceptions.length > 0) {
                buffer.append("\n");
                buffer.append("throws\n");
                for (PsiClassType exception : exceptions) {
                    buffer.append("    ");
                    buffer.append(PsiFormatUtil.formatType((PsiType)exception, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                    buffer.append("\n");
                }
            }
            return buffer.toString();
        }
        return null;
    }

    public void changeSignature(PsiMethod psiMethod) {
        ArrayList<ParameterInfoImpl> newParameters = this.patchParams(psiMethod);
        PsiType expressionType = this.getChangedReturnType(psiMethod);
        ChangeSignatureProcessor csp = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, false, null, psiMethod.getName(), expressionType != null ? expressionType : psiMethod.getReturnType(), newParameters.toArray(new ParameterInfoImpl[newParameters.size()]));
        csp.run();
    }

    @Nullable
    private PsiType getChangedReturnType(PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        if (returnType != null) {
            PsiElement parent = this.getMatchEnd().getParent();
            if (parent instanceof PsiExpression) {
                JavaPsiFacade facade;
                PsiClassType expressionType;
                PsiClass psiClass;
                JavaResolveResult result;
                PsiElement element;
                if (parent instanceof PsiMethodCallExpression) {
                    PsiType type;
                    JavaResolveResult result2 = ((PsiMethodCallExpression)parent).resolveMethodGenerics();
                    PsiMethod method = (PsiMethod)result2.getElement();
                    if (method != null && (type = method.getReturnType()) != null && Match.weakerType(psiMethod, returnType, type = result2.getSubstitutor().substitute(type))) {
                        return type;
                    }
                } else if (parent instanceof PsiReferenceExpression && (element = (result = ((PsiReferenceExpression)parent).advancedResolve(false)).getElement()) instanceof PsiMember && (psiClass = ((PsiMember)element).getContainingClass()) != null && Match.weakerType(psiMethod, returnType, (PsiType)(expressionType = (facade = JavaPsiFacade.getInstance((Project)parent.getProject())).getElementFactory().createType(psiClass, result.getSubstitutor())))) {
                    return expressionType;
                }
            } else if (parent instanceof PsiExpressionList) {
                JavaResolveResult result;
                PsiMethod method;
                Object[] expressions = ((PsiExpressionList)parent).getExpressions();
                PsiElement call = parent.getParent();
                if (call instanceof PsiMethodCallExpression && (method = (PsiMethod)(result = ((PsiMethodCallExpression)call).resolveMethodGenerics()).getElement()) != null) {
                    PsiType type;
                    int idx = ArrayUtil.find((Object[])expressions, (Object)this.getMatchEnd());
                    PsiParameter[] psiParameters = method.getParameterList().getParameters();
                    if (idx >= 0 && idx < psiParameters.length && Match.weakerType(psiMethod, returnType, type = result.getSubstitutor().substitute(psiParameters[idx].getType()))) {
                        return type;
                    }
                }
            } else if (parent instanceof PsiLocalVariable) {
                PsiType localVariableType = ((PsiLocalVariable)parent).getType();
                if (Match.weakerType(psiMethod, returnType, localVariableType)) {
                    return localVariableType;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod replacedMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                LOG.assertTrue(replacedMethod != null);
                PsiType replacedMethodReturnType = replacedMethod.getReturnType();
                if (Match.weakerType(psiMethod, returnType, replacedMethodReturnType)) {
                    return replacedMethodReturnType;
                }
            }
        }
        return null;
    }

    private static boolean weakerType(PsiMethod psiMethod, PsiType returnType, PsiType currentType) {
        PsiTypeParameter[] typeParameters = psiMethod.getTypeParameters();
        PsiSubstitutor substitutor = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getResolveHelper().inferTypeArguments(typeParameters, new PsiType[]{returnType}, new PsiType[]{currentType}, PsiUtil.getLanguageLevel((PsiElement)psiMethod));
        return !TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)substitutor.substitute(returnType));
    }

    private ArrayList<ParameterInfoImpl> patchParams(PsiMethod psiMethod) {
        ArrayList<ParameterInfoImpl> newParameters = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] oldParameters = psiMethod.getParameterList().getParameters();
        for (int i = 0; i < oldParameters.length; ++i) {
            PsiParameter oldParameter = oldParameters[i];
            PsiType type = oldParameter.getType();
            for (PsiVariable variable : this.myChangedParams.keySet()) {
                if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)oldParameter)) continue;
                type = this.myChangedParams.get(variable);
                break;
            }
            newParameters.add(new ParameterInfoImpl(i, oldParameter.getName(), type));
        }
        return newParameters;
    }

    public PsiFile getFile() {
        return this.getMatchStart().getContainingFile();
    }
}

