/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classRefs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classRefs.ClassReferenceVisitor;
import com.intellij.refactoring.util.classRefs.ClassReferenceVisitorAdapter;
import com.intellij.refactoring.util.classRefs.DelegatingClassReferenceVisitor;

public class ClassInstanceScanner
extends DelegatingClassReferenceVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.classRefs.ClassInstanceScanner");
    private final PsiClass myClass;
    private final ClassInstanceReferenceVisitor myVisitor;

    public ClassInstanceScanner(PsiClass aClass, ClassInstanceReferenceVisitor visitor) {
        this(aClass, ClassReferenceVisitorAdapter.INSTANCE, visitor);
    }

    public ClassInstanceScanner(PsiClass aClass, ClassReferenceVisitor delegate, ClassInstanceReferenceVisitor visitor) {
        super(delegate);
        this.myClass = aClass;
        this.myVisitor = visitor;
    }

    @Override
    public void visitLocalVariableDeclaration(PsiLocalVariable variable, ClassReferenceVisitor.TypeOccurence occurence) {
        this.visitVariable((PsiVariable)variable, occurence);
    }

    @Override
    public void visitFieldDeclaration(PsiField field, ClassReferenceVisitor.TypeOccurence occurence) {
        this.visitVariable((PsiVariable)field, occurence);
    }

    @Override
    public void visitParameterDeclaration(PsiParameter parameter, ClassReferenceVisitor.TypeOccurence occurence) {
        this.visitVariable((PsiVariable)parameter, occurence);
    }

    private void visitVariable(PsiVariable variable, ClassReferenceVisitor.TypeOccurence occurence) {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myClass.getProject());
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)projectScope, (boolean)false)) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiExpression)) continue;
            this.processExpression((PsiExpression)element, occurence, (PsiElement)variable);
        }
    }

    @Override
    public void visitMethodReturnType(PsiMethod method, ClassReferenceVisitor.TypeOccurence occurence) {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myClass.getProject());
        for (PsiReference ref : ReferencesSearch.search((PsiElement)method, (SearchScope)projectScope, (boolean)false)) {
            PsiElement parent;
            PsiElement element = ref.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiMethodCallExpression)) continue;
            this.processExpression((PsiExpression)((PsiMethodCallExpression)parent), occurence, (PsiElement)method);
        }
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression typeCastExpression, ClassReferenceVisitor.TypeOccurence occurence) {
        this.processExpression((PsiExpression)typeCastExpression, occurence, null);
    }

    @Override
    public void visitNewExpression(PsiNewExpression newExpression, ClassReferenceVisitor.TypeOccurence occurence) {
        this.processExpression((PsiExpression)newExpression, occurence, null);
    }

    private void processExpression(PsiExpression expression, ClassReferenceVisitor.TypeOccurence occurence, PsiElement referencedElement) {
        if (occurence.outermostType == null || !(occurence.outermostType instanceof PsiArrayType)) {
            ClassInstanceScanner.processNonArrayExpression(this.myVisitor, expression, referencedElement);
        } else {
            PsiType type = occurence.outermostType;
            PsiExpression result = RefactoringUtil.outermostParenthesizedExpression(expression);
            while (type instanceof PsiArrayType && result.getParent() instanceof PsiArrayAccessExpression) {
                type = ((PsiArrayType)type).getComponentType();
                result = RefactoringUtil.outermostParenthesizedExpression((PsiExpression)((PsiArrayAccessExpression)result.getParent()));
            }
            if (type == null || !(type instanceof PsiArrayType)) {
                ClassInstanceScanner.processNonArrayExpression(this.myVisitor, result, referencedElement);
            }
        }
    }

    public static void processNonArrayExpression(ClassInstanceReferenceVisitor visitor, PsiExpression expression, PsiElement referencedElement) {
        PsiElement parent = (expression = RefactoringUtil.outermostParenthesizedExpression(expression)).getParent();
        if (parent instanceof PsiReferenceExpression && expression == ((PsiReferenceExpression)parent).getQualifierExpression()) {
            visitor.visitQualifier((PsiReferenceExpression)parent, expression, referencedElement);
        } else if (parent instanceof PsiTypeCastExpression) {
            visitor.visitTypeCast((PsiTypeCastExpression)parent, expression, referencedElement);
        } else if (parent instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)parent;
            PsiMethod enclosingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, PsiMethod.class);
            PsiType returnType = enclosingMethod != null ? enclosingMethod.getReturnType() : null;
            visitor.visitReadUsage(expression, returnType, referencedElement);
        } else if (parent instanceof PsiStatement) {
            visitor.visitReadUsage(expression, null, referencedElement);
        } else if (parent instanceof PsiExpressionList) {
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement pparent = expressionList.getParent();
            if (pparent instanceof PsiStatement) {
                visitor.visitReadUsage(expression, null, referencedElement);
            } else if (pparent instanceof PsiCallExpression) {
                PsiCallExpression callExpression = (PsiCallExpression)pparent;
                PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
                PsiMethod method = callExpression.resolveMethod();
                if (method != null) {
                    PsiParameter[] parameters;
                    int index = -1;
                    for (int i = 0; i < arguments.length; ++i) {
                        PsiExpression argument = arguments[i];
                        if (!argument.equals(expression)) continue;
                        index = i;
                        break;
                    }
                    if (index >= 0 && (parameters = method.getParameterList().getParameters()).length > index) {
                        visitor.visitReadUsage(expression, parameters[index].getType(), referencedElement);
                    }
                }
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            if (expression.equals(assignmentExpression.getRExpression())) {
                visitor.visitReadUsage(expression, assignmentExpression.getLExpression().getType(), referencedElement);
            } else {
                visitor.visitWriteUsage(expression, assignmentExpression.getRExpression().getType(), referencedElement);
            }
        } else if (RefactoringUtil.isAssignmentLHS((PsiElement)expression)) {
            visitor.visitWriteUsage(expression, null, referencedElement);
        } else if (parent instanceof PsiVariable) {
            visitor.visitReadUsage(expression, ((PsiVariable)parent).getType(), referencedElement);
        } else if (parent instanceof PsiExpression) {
            visitor.visitReadUsage(expression, null, referencedElement);
        } else {
            LOG.error("Unknown variation of class instance usage");
        }
    }

    public static interface ClassInstanceReferenceVisitor {
        public void visitQualifier(PsiReferenceExpression var1, PsiExpression var2, PsiElement var3);

        public void visitTypeCast(PsiTypeCastExpression var1, PsiExpression var2, PsiElement var3);

        public void visitReadUsage(PsiExpression var1, PsiType var2, PsiElement var3);

        public void visitWriteUsage(PsiExpression var1, PsiType var2, PsiElement var3);
    }
}

