/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ParameterData {
    private final String myName;
    private final String myParameterName;
    private final PsiType myType;
    private String myFieldName;
    private String mySetterName;
    private String myDefaultValue;
    private boolean myInsertSetter = true;
    private static final Logger LOG = Logger.getInstance((String)("#" + ParameterData.class.getName()));

    public ParameterData(String name, String parameterName, PsiType type) {
        this.myName = name;
        this.myParameterName = parameterName;
        this.myType = type;
    }

    public static void createFromConstructor(PsiMethod constructor, Map<String, ParameterData> result) {
        for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
            ParameterData.initParameterData(parameter, result);
        }
        PsiMethod chainedConstructor = ParameterData.getChainedConstructor(constructor);
        if (chainedConstructor != null) {
            PsiCodeBlock constructorBody = constructor.getBody();
            LOG.assertTrue(constructorBody != null);
            PsiStatement thisStatement = constructorBody.getStatements()[0];
            PsiExpression thisExpression = ((PsiExpressionStatement)thisStatement).getExpression();
            PsiExpression[] args = ((PsiMethodCallExpression)thisExpression).getArgumentList().getExpressions();
            int i = 0;
            for (PsiParameter parameter : chainedConstructor.getParameterList().getParameters()) {
                if (parameter.isVarArgs()) continue;
                ParameterData parameterData = ParameterData.initParameterData(parameter, result);
                parameterData.setDefaultValue(args[i++].getText());
            }
        }
    }

    @Nullable
    public static PsiMethod getChainedConstructor(PsiMethod constructor) {
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpr;
        PsiExpression expression;
        PsiCodeBlock constructorBody = constructor.getBody();
        LOG.assertTrue(constructorBody != null);
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && "this".equals((methodExpr = (methodCallExpression = (PsiMethodCallExpression)expression).getMethodExpression()).getReferenceName())) {
            return (PsiMethod)methodExpr.resolve();
        }
        return null;
    }

    private static ParameterData initParameterData(PsiParameter parameter, Map<String, ParameterData> result) {
        String paramName;
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)parameter.getProject());
        String pureParamName = styleManager.variableNameToPropertyName(paramName = parameter.getName(), VariableKind.PARAMETER);
        ParameterData parameterData = result.get(pureParamName);
        if (parameterData == null) {
            parameterData = new ParameterData(pureParamName, paramName, parameter.getType());
            parameterData.setFieldName(styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)pureParamName, null, (PsiType)parameter.getType()).names[0]);
            parameterData.setSetterName(PropertyUtil.suggestSetterName((String)pureParamName));
            result.put(pureParamName, parameterData);
        }
        return parameterData;
    }

    public PsiType getType() {
        return this.myType;
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    public String getSetterName() {
        return this.mySetterName;
    }

    public String getParamName() {
        return this.myParameterName;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public boolean isInsertSetter() {
        return this.myInsertSetter;
    }

    public void setFieldName(String fieldName) {
        this.myFieldName = fieldName;
    }

    public void setSetterName(String setterName) {
        this.mySetterName = setterName;
    }

    public void setDefaultValue(String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public void setInsertSetter(boolean insertSetter) {
        this.myInsertSetter = insertSetter;
    }
}

