/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonCodeUsageInfoFactory
implements TextOccurrencesUtil.UsageInfoFactory {
    private final PsiElement myElement;
    private final String myStringToReplace;

    public NonCodeUsageInfoFactory(PsiElement element, String stringToReplace) {
        this.myElement = element;
        this.myStringToReplace = stringToReplace;
    }

    @Override
    @Nullable
    public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
        if (usage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/NonCodeUsageInfoFactory.createUsageInfo must not be null");
        }
        PsiElement namedElement = TargetElementUtilBase.getInstance().getNamedElement(usage, startOffset);
        if (namedElement != null) {
            return null;
        }
        int start = usage.getTextRange().getStartOffset();
        return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start + startOffset), (int)(start + endOffset), (PsiElement)this.myElement, (String)this.myStringToReplace);
    }
}

