/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassUsageViewDescriptor;
import com.intellij.refactoring.inlineSuperClass.usageInfo.CopyDefaultConstructorUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.InlineSuperCallUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.RemoveImportUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.RemoveQualifierUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceConstructorUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceExtendsListUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceReferenceUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceStaticImportUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceWithSubtypeUsageInfo;
import com.intellij.refactoring.memberPushDown.PushDownConflicts;
import com.intellij.refactoring.memberPushDown.PushDownProcessor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class InlineSuperClassRefactoringProcessor
extends FixableUsagesRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance((String)("#" + InlineSuperClassRefactoringProcessor.class.getName()));
    private final PsiClass mySuperClass;
    private final PsiClass[] myTargetClasses;
    private final MemberInfo[] myMemberInfos;

    public InlineSuperClassRefactoringProcessor(Project project, PsiClass superClass, PsiClass ... targetClasses) {
        super(project);
        this.mySuperClass = superClass;
        this.myTargetClasses = targetClasses;
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(this.mySuperClass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return true;
            }
        });
        List members = memberInfoStorage.getClassMemberInfos(this.mySuperClass);
        for (MemberInfo member : members) {
            member.setChecked(true);
        }
        this.myMemberInfos = members.toArray(new MemberInfo[members.size()]);
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new InlineSuperClassUsageViewDescriptor(this.mySuperClass);
    }

    @Override
    protected void findUsages(final @NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor.findUsages must not be null");
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        final PsiElementFactory elementFactory = facade.getElementFactory();
        final PsiResolveHelper resolveHelper = facade.getResolveHelper();
        ReferencesSearch.search((PsiElement)this.mySuperClass).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (element instanceof PsiJavaCodeReferenceElement) {
                    PsiImportStaticStatement staticImportStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
                    if (staticImportStatement != null) {
                        usages.add(new ReplaceStaticImportUsageInfo(staticImportStatement, InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                    } else {
                        PsiImportStatement importStatement = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
                        if (importStatement != null) {
                            usages.add(new RemoveImportUsageInfo(importStatement));
                        } else {
                            PsiElement parent = element.getParent();
                            if (parent instanceof PsiReferenceList) {
                                PsiClass inheritor;
                                PsiElement pparent = parent.getParent();
                                if (pparent instanceof PsiClass && (parent.equals((inheritor = (PsiClass)pparent).getExtendsList()) || parent.equals(inheritor.getImplementsList()))) {
                                    usages.add(new ReplaceExtendsListUsageInfo((PsiJavaCodeReferenceElement)element, InlineSuperClassRefactoringProcessor.this.mySuperClass, inheritor));
                                }
                            } else {
                                PsiClass targetClass = InlineSuperClassRefactoringProcessor.this.myTargetClasses[0];
                                PsiClassType targetClassType = elementFactory.createType(targetClass, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)InlineSuperClassRefactoringProcessor.this.mySuperClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                                if (parent instanceof PsiTypeElement) {
                                    PsiType superClassType = ((PsiTypeElement)parent).getType();
                                    PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                                    usages.add(new ReplaceWithSubtypeUsageInfo((PsiTypeElement)parent, elementFactory.createType(targetClass, subst), InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                                } else if (parent instanceof PsiNewExpression) {
                                    PsiClassType newType = elementFactory.createType(targetClass, InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(((PsiNewExpression)parent).getType(), targetClassType, resolveHelper, targetClass));
                                    usages.add(new ReplaceConstructorUsageInfo((PsiNewExpression)parent, (PsiType)newType, InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                                } else if (parent instanceof PsiJavaCodeReferenceElement) {
                                    usages.add(new ReplaceReferenceUsageInfo(((PsiJavaCodeReferenceElement)parent).getQualifier(), InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                                }
                            }
                        }
                    }
                }
                return true;
            }
        });
        block0: for (PsiClass targetClass : this.myTargetClasses) {
            for (MemberInfo memberInfo : this.myMemberInfos) {
                PsiMember member = (PsiMember)memberInfo.getMember();
                for (PsiReference reference : ReferencesSearch.search((PsiElement)member, (SearchScope)member.getUseScope(), (boolean)true)) {
                    PsiElement element = reference.getElement();
                    if (!(element instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)element).getQualifierExpression() instanceof PsiSuperExpression) || !PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)element, (boolean)false)) continue;
                    usages.add(new RemoveQualifierUsageInfo((PsiReferenceExpression)element));
                }
            }
            PsiMethod[] superConstructors = this.mySuperClass.getConstructors();
            for (PsiMethod constructor : targetClass.getConstructors()) {
                PsiMethod superConstructor2;
                PsiReferenceExpression methodExpression;
                PsiExpression expression;
                PsiStatement firstConstrStatement;
                PsiCodeBlock constrBody = constructor.getBody();
                LOG.assertTrue(constrBody != null);
                PsiStatement[] statements = constrBody.getStatements();
                if (statements.length > 0 && (firstConstrStatement = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)firstConstrStatement).getExpression()) instanceof PsiMethodCallExpression && (methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression()).getText().equals("super") && (superConstructor2 = ((PsiMethodCallExpression)expression).resolveMethod()) != null && superConstructor2.getBody() != null) {
                    usages.add(new InlineSuperCallUsageInfo((PsiMethodCallExpression)expression));
                    continue;
                }
                for (PsiMethod superConstructor2 : superConstructors) {
                    if (superConstructor2.getParameterList().getParametersCount() != 0) continue;
                    PsiExpression expression2 = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText("super()", (PsiElement)constructor);
                    usages.add(new InlineSuperCallUsageInfo((PsiMethodCallExpression)expression2, constrBody));
                }
            }
            if (targetClass.getConstructors().length != 0) continue;
            for (PsiMethod superConstructor : superConstructors) {
                if (superConstructor.getParameterList().getParametersCount() != 0) continue;
                usages.add(new CopyDefaultConstructorUsageInfo(targetClass, superConstructor));
                continue block0;
            }
        }
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        PushDownConflicts pushDownConflicts = new PushDownConflicts(this.mySuperClass, this.myMemberInfos);
        for (PsiClass targetClass : this.myTargetClasses) {
            for (MemberInfo info : this.myMemberInfos) {
                PsiMember member = (PsiMember)info.getMember();
                pushDownConflicts.checkMemberPlacementInTargetClassConflict(targetClass, member);
            }
        }
        MultiMap<PsiElement, String> conflictsMap = pushDownConflicts.getConflicts();
        for (PsiElement element : conflictsMap.keySet()) {
            conflicts.put((Object)element, conflictsMap.get((Object)element));
        }
        InlineSuperClassRefactoringProcessor.checkConflicts(refUsages, (MultiMap<PsiElement, String>)conflicts);
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        new PushDownProcessor(this.mySuperClass.getProject(), this.myMemberInfos, this.mySuperClass, new DocCommentPolicy(0)){

            @Override
            protected boolean showConflicts(MultiMap<PsiElement, String> conflicts) {
                return true;
            }
        }.run();
        RefactoringUtil.sortDepthFirstRightLeftOrder(usages);
        for (UsageInfo usageInfo : usages) {
            if (usageInfo instanceof ReplaceExtendsListUsageInfo) continue;
            try {
                ((FixableUsageInfo)usageInfo).fixUsage();
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
            }
        }
        this.replaceInnerTypeUsages();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ReplaceExtendsListUsageInfo)) continue;
            ((ReplaceExtendsListUsageInfo)usage).fixUsage();
        }
        try {
            this.mySuperClass.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void replaceInnerTypeUsages() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiElementFactory elementFactory = facade.getElementFactory();
        final PsiResolveHelper resolveHelper = facade.getResolveHelper();
        HashMap replacementMap = new HashMap();
        for (final PsiClass targetClass : this.myTargetClasses) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.mySuperClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            final PsiClassType targetClassType = elementFactory.createType(targetClass, superClassSubstitutor);
            targetClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)replacementMap, elementFactory){
                final /* synthetic */ Map val$replacementMap;
                final /* synthetic */ PsiElementFactory val$elementFactory;
                {
                    this.val$replacementMap = map;
                    this.val$elementFactory = psiElementFactory;
                }

                public void visitTypeElement(PsiTypeElement typeElement) {
                    super.visitTypeElement(typeElement);
                    PsiType superClassType = typeElement.getType();
                    if (PsiUtil.resolveClassInType((PsiType)superClassType) == InlineSuperClassRefactoringProcessor.this.mySuperClass) {
                        PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                        this.val$replacementMap.put(new UsageInfo((PsiElement)typeElement), this.val$elementFactory.createTypeElement((PsiType)this.val$elementFactory.createType(targetClass, subst)));
                    }
                }

                public void visitNewExpression(PsiNewExpression expression) {
                    super.visitNewExpression(expression);
                    PsiType superClassType = expression.getType();
                    if (PsiUtil.resolveClassInType((PsiType)superClassType) == InlineSuperClassRefactoringProcessor.this.mySuperClass) {
                        PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                        try {
                            this.val$replacementMap.put(new UsageInfo((PsiElement)expression), this.val$elementFactory.createExpressionFromText("new " + this.val$elementFactory.createType(targetClass, subst).getCanonicalText() + expression.getArgumentList().getText(), (PsiElement)expression));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            });
        }
        try {
            for (Map.Entry elementEntry : replacementMap.entrySet()) {
                PsiElement element = ((UsageInfo)elementEntry.getKey()).getElement();
                if (element == null) continue;
                element.replace((PsiElement)elementEntry.getValue());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiSubstitutor getSuperClassSubstitutor(PsiType superClassType, PsiClassType targetClassType, PsiResolveHelper resolveHelper, PsiClass targetClass) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass)) {
            subst = subst.put(typeParameter, resolveHelper.getSubstitutionForTypeParameter(typeParameter, (PsiType)targetClassType, superClassType, false, PsiUtil.getLanguageLevel((PsiElement)targetClass)));
        }
        return subst;
    }

    @Override
    protected String getCommandName() {
        return "Inline Super Class";
    }
}

