/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodProcessor;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialogBase;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

public class ConvertToInstanceMethodDialog
extends MoveInstanceMethodDialogBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodDialog");

    public ConvertToInstanceMethodDialog(PsiMethod method, PsiParameter[] variables) {
        super(method, (PsiVariable[])variables, ConvertToInstanceMethodHandler.REFACTORING_NAME);
        this.init();
    }

    @Override
    protected void doAction() {
        PsiVariable targetVariable = (PsiVariable)this.myList.getSelectedValue();
        LOG.assertTrue(targetVariable instanceof PsiParameter);
        ConvertToInstanceMethodProcessor processor = new ConvertToInstanceMethodProcessor(this.myMethod.getProject(), this.myMethod, (PsiParameter)targetVariable, this.myVisibilityPanel.getVisibility());
        if (!this.verifyTargetClass(processor.getTargetClass())) {
            return;
        }
        this.invokeRefactoring(processor);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.convertToInstanceMethod");
    }

    protected JComponent createCenterPanel() {
        Box vBox = Box.createVerticalBox();
        Box labelBox = Box.createHorizontalBox();
        JLabel label = new JLabel();
        labelBox.add(label);
        labelBox.add(Box.createHorizontalGlue());
        vBox.add(labelBox);
        vBox.add(Box.createVerticalStrut(4));
        vBox.add(this.createListAndVisibilityPanels());
        label.setText(RefactoringBundle.message((String)"moveInstanceMethod.select.an.instance.parameter"));
        return vBox;
    }

    @Override
    protected JList createTargetVariableChooser() {
        final JList variableChooser = super.createTargetVariableChooser();
        variableChooser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Point point = e.getPoint();
                int index = variableChooser.locationToIndex(point);
                if (index == -1) {
                    return;
                }
                if (!variableChooser.getCellBounds(index, index).contains(point)) {
                    return;
                }
                ConvertToInstanceMethodDialog.this.doRefactorAction();
            }
        });
        return variableChooser;
    }
}

