/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.ui.RowEditableTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ExceptionsTableModel
extends AbstractTableModel
implements RowEditableTableModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ParameterTableModel");
    private List<PsiTypeCodeFragment> myTypeCodeFraments;
    private final PsiElement myContext;
    private List<ThrownExceptionInfo> myExceptionInfos;

    public ExceptionsTableModel(PsiElement context) {
        this.myContext = context;
    }

    public ThrownExceptionInfo[] getThrownExceptions() {
        return this.myExceptionInfos.toArray(new ThrownExceptionInfo[this.myExceptionInfos.size()]);
    }

    public void addRow() {
        this.myExceptionInfos.add(new ThrownExceptionInfo());
        this.myTypeCodeFraments.add(this.createParameterTypeCodeFragment("", this.myContext));
        this.fireTableRowsInserted(this.myTypeCodeFraments.size() - 1, this.myTypeCodeFraments.size() - 1);
    }

    public void removeRow(int index) {
        this.myExceptionInfos.remove(index);
        this.myTypeCodeFraments.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void exchangeRows(int index1, int index2) {
        Collections.swap(this.myExceptionInfos, index1, index2);
        Collections.swap(this.myTypeCodeFraments, index1, index2);
        if (index1 < index2) {
            this.fireTableRowsUpdated(index1, index2);
        } else {
            this.fireTableRowsUpdated(index2, index1);
        }
    }

    @Override
    public int getRowCount() {
        return this.myTypeCodeFraments.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.myTypeCodeFraments.get(rowIndex);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return RefactoringBundle.message((String)"column.name.type");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    PsiType getTypeByRow(int row) {
        PsiType type;
        Object typeValueAt = this.getValueAt(row, 0);
        LOG.assertTrue(typeValueAt instanceof PsiTypeCodeFragment);
        try {
            type = ((PsiTypeCodeFragment)typeValueAt).getType();
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e1) {
            type = null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e1) {
            type = null;
        }
        return type;
    }

    public void setTypeInfos(PsiMethod method) {
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        this.myTypeCodeFraments = new ArrayList<PsiTypeCodeFragment>(referencedTypes.length);
        this.myExceptionInfos = new ArrayList<ThrownExceptionInfo>(referencedTypes.length);
        for (int i = 0; i < referencedTypes.length; ++i) {
            CanonicalTypes.Type typeWrapper = CanonicalTypes.createTypeWrapper((PsiType)referencedTypes[i]);
            PsiTypeCodeFragment typeCodeFragment = this.createParameterTypeCodeFragment(typeWrapper.getTypeText(), (PsiElement)method.getThrowsList());
            typeWrapper.addImportsTo((JavaCodeFragment)typeCodeFragment);
            this.myTypeCodeFraments.add(typeCodeFragment);
            this.myExceptionInfos.add(new ThrownExceptionInfo(i, referencedTypes[i]));
        }
    }

    PsiTypeCodeFragment createParameterTypeCodeFragment(String typeText, PsiElement context) {
        return JavaPsiFacade.getInstance((Project)this.myContext.getProject()).getElementFactory().createTypeCodeFragment(typeText, context, false, true, true);
    }

    PsiTypeCodeFragment[] getTypeCodeFragments() {
        return this.myTypeCodeFraments.toArray(new PsiTypeCodeFragment[this.myTypeCodeFraments.size()]);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

