/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameLogicalRootWeigher
extends ProximityWeigher {
    @Override
    public Comparable weigh(@NotNull PsiElement element, ProximityLocation location) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/proximity/SameLogicalRootWeigher.weigh must not be null");
        }
        LogicalRoot elementRoot = SameLogicalRootWeigher.findLogicalRoot(element);
        LogicalRoot contextRoot = SameLogicalRootWeigher.findLogicalRoot(location.getPosition());
        return Boolean.valueOf(elementRoot != null && contextRoot != null && elementRoot.equals(contextRoot));
    }

    @Nullable
    private static LogicalRoot findLogicalRoot(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        return LogicalRootsManager.getLogicalRootsManager((Project)element.getProject()).findLogicalRoot(file);
    }
}

