/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PackagePrefixFileSystemItem
extends PsiElementBase
implements PsiFileSystemItem {
    private final PsiDirectory myDirectory;
    private final int myIndex;
    private final PsiPackage[] myPackages;

    public static PackagePrefixFileSystemItem create(PsiDirectory directory) {
        ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        for (PsiPackage cur = JavaDirectoryService.getInstance().getPackage(directory); cur != null; cur = cur.getParentPackage()) {
            packages.add(0, cur);
        }
        return new PackagePrefixFileSystemItem(directory, 0, packages.toArray(new PsiPackage[packages.size()]));
    }

    private PackagePrefixFileSystemItem(PsiDirectory directory, int index, PsiPackage[] packages) {
        this.myDirectory = directory;
        this.myIndex = index;
        this.myPackages = packages;
    }

    @NotNull
    public String getName() {
        String string = this.myPackages[this.myIndex].getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.setName must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isDirectory() {
        return true;
    }

    public PsiFileSystemItem getParent() {
        return this.myIndex > 0 ? new PackagePrefixFileSystemItem(this.myDirectory, this.myIndex - 1, this.myPackages) : this.myDirectory.getParent();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return null;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return 0;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    @NonNls
    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.textToCharArray must not return null");
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.textMatches must not be null");
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.textMatches must not be null");
        }
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.accept must not be null");
        }
    }

    public PsiElement copy() {
        return null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.add must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.checkAdd must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.replace must not be null");
        }
        throw new IncorrectOperationException();
    }

    public boolean isValid() {
        return this.myDirectory.isValid();
    }

    public boolean isWritable() {
        VirtualFile file = this.getVirtualFile();
        return file != null && file.isWritable();
    }

    public boolean isPhysical() {
        VirtualFile file = this.getVirtualFile();
        return file != null && !(file.getFileSystem() instanceof DummyFileSystem);
    }

    @Nullable
    public ASTNode getNode() {
        return null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.processChildren(processor);
        }
        return processor.execute((PsiElement)new PackagePrefixFileSystemItem(this.myDirectory, this.myIndex + 1, this.myPackages));
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.getLanguage must not return null");
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myDirectory.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        if (this.myIndex == this.myPackages.length - 1) {
            psiElementArray = this.myDirectory.getChildren();
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = new PackagePrefixFileSystemItem(this.myDirectory, this.myIndex + 1, this.myPackages);
        }
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItem.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public boolean canNavigate() {
        return this.getVirtualFile() != null;
    }

    public VirtualFile getVirtualFile() {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.myDirectory.getIcon(flags);
    }
}

