/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.ClassCollectingProcessor;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    private final CachedValue<MostlySingularMultiMap<String, ClassCollectingProcessor.ResultWithContext>> myResolveCache;
    @NonNls
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create((String)"LANGUAGE_LEVEL", (NotNullFunction)new NotNullFunction<PsiJavaFileBaseImpl, LanguageLevel>(){

        @NotNull
        public LanguageLevel fun(PsiJavaFileBaseImpl file) {
            LanguageLevel languageLevel = file.getLanguageLevelInner();
            if (languageLevel == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1.fun must not return null");
            }
            return languageLevel;
        }
    });

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new MyCacheBuilder(), false);
    }

    @Override
    protected PsiJavaFileBaseImpl clone() {
        PsiJavaFileBaseImpl clone = (PsiJavaFileBaseImpl)super.clone();
        clone.clearCaches();
        return clone;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray;
        StubElement stub = this.getStub();
        if (stub != null) {
            psiClassArray = (PsiClass[])stub.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getClasses must not return null");
            return psiClassArray;
        }
        psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, Constants.PSI_CLASS_ARRAY_CONSTRUCTOR);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getClasses must not return null");
    }

    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getPackageName() {
        String string;
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getStub();
        if (stub != null) {
            String string2 = stub.getPackageName();
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getPackageName must not return null");
        }
        PsiPackageStatement statement = this.getPackageStatement();
        if (statement == null) {
            return "";
        }
        String string3 = statement.getPackageName();
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getPackageName must not return null");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiImportList getImportList() {
        PsiImportList psiImportList;
        StubElement stub = this.getStub();
        if (stub != null) {
            psiImportList = ((PsiImportList[])stub.getChildrenByType((IElementType)JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY))[0];
            if (psiImportList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImportList must not return null");
            return psiImportList;
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        assert (node != null);
        psiImportList = (PsiImportList)node.getPsi();
        if (psiImportList != null) return psiImportList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImportList must not return null");
    }

    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = array.toArray(new PsiElement[array.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getOnDemandImports must not return null");
        }
        return psiElementArray;
    }

    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(new PsiClass[array.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getSingleClassImports must not return null");
        }
        return psiClassArray;
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, (PsiElement)aClass)) continue;
            return statement.getImportReference();
        }
        return null;
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImplicitlyImportedPackages must not return null");
        }
        return IMPLICIT_IMPORTS;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImplicitlyImportedPackageReferences must not return null");
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.processDeclarations must not be null");
        }
        if (processor instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor;
            String name = hint.getName(state);
            MostlySingularMultiMap cache = (MostlySingularMultiMap)this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor, state);
            return name != null ? cache.processForKey((Object)name, (Processor)cacheProcessor) : cache.processAllValues((Processor)cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiImportList importList;
        PsiImportStaticStatement[] importStaticStatements;
        String name;
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) {
            PsiImportStatement[] importStatements;
            PsiClass[] classes;
            for (PsiClass aClass : classes = this.getClasses()) {
                if (processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
            PsiImportList importList2 = this.getImportList();
            for (PsiImportStatement psiImportStatement : importStatements = importList2.getImportStatements()) {
                PsiElement resolved;
                String refText;
                if (psiImportStatement.isOnDemand() || name != null && ((refText = psiImportStatement.getQualifiedName()) == null || !refText.endsWith(name)) || !((resolved = psiImportStatement.resolve()) instanceof PsiClass)) continue;
                processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)psiImportStatement);
                if (processor.execute(resolved, state)) continue;
                return false;
            }
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            String packageName = this.getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(packageName);
            if (aPackage != null && !aPackage.processDeclarations(processor, state, null, place)) {
                return false;
            }
            for (PsiImportStatement statement : importStatements) {
                PsiElement resolved;
                if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
                processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement);
                PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state, place);
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.PACKAGE)) {
            PsiPackage rootPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage("");
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)rootPackage);
            if (rootPackage != null) {
                rootPackage.processDeclarations(processor, state, null, place);
            }
        }
        if ((importStaticStatements = (importList = this.getImportList()).getImportStaticStatements()).length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor, null);
            for (PsiImportStatement psiImportStatement : importStaticStatements) {
                if (psiImportStatement.isOnDemand()) continue;
                String referenceName = psiImportStatement.getReferenceName();
                PsiClass targetElement = psiImportStatement.resolveTargetClass();
                if (targetElement == null) continue;
                staticImportProcessor.setNameToFilter(referenceName);
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStatement);
                boolean result = targetElement.processDeclarations((PsiScopeProcessor)staticImportProcessor, state, lastParent, place);
                if (result) continue;
                return false;
            }
            for (PsiImportStatement psiImportStatement : importStaticStatements) {
                PsiClass targetElement;
                if (!psiImportStatement.isOnDemand() || (targetElement = psiImportStatement.resolveTargetClass()) == null) continue;
                staticImportProcessor.setNameToFilter(null);
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStatement);
                boolean result = targetElement.processDeclarations((PsiScopeProcessor)staticImportProcessor, state, lastParent, place);
                if (result) continue;
                return false;
            }
            staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) {
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiJavaCodeReferenceElement[] implicitlyImported = this.getImplicitlyImportedPackageReferences();
            for (PsiImportStatement psiImportStatement : implicitlyImported) {
                PsiElement resolved = psiImportStatement.resolve();
                if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!target.processDeclarations(processor, substitutor, null, place)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners;
            for (PsiClass inner : inners = ((PsiClass)target).getInnerClasses()) {
                if (processor.execute((PsiElement)inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.assertTrue(false);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = StdLanguages.JAVA;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getLanguage must not return null");
        }
        return language;
    }

    public boolean importClass(PsiClass aClass) {
        return JavaCodeStyleManager.getInstance((Project)this.getProject()).addImport((PsiJavaFile)this, aClass);
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = (LanguageLevel)LANGUAGE_LEVEL_KEY.getValue((UserDataHolder)this);
        if (languageLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getLanguageLevel must not return null");
        }
        return languageLevel;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData((Key)LANGUAGE_LEVEL_KEY, null);
    }

    private LanguageLevel getLanguageLevelInner() {
        LanguageLevel level;
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = (LanguageLevel)this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)this.getUserData(FileBasedIndex.VIRTUAL_FILE);
        }
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevelProjectExtension.getInstance((Project)this.getProject()).getLanguageLevel();
        }
        VirtualFile folder = virtualFile.getParent();
        if (folder != null && (level = (LanguageLevel)folder.getUserData(LanguageLevel.KEY)) != null) {
            return level;
        }
        Project project = this.getProject();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
        if (sourceRoot != null) {
            VirtualFile[] files;
            String relativePath = VfsUtil.getRelativePath((VirtualFile)folder, (VirtualFile)sourceRoot, (char)'/');
            LOG.assertTrue(relativePath != null);
            List orderEntries = index.getOrderEntriesForFile(virtualFile);
            if (orderEntries.isEmpty()) {
                LOG.error("Inconsistent: " + DirectoryIndex.getInstance(project).getInfoForDirectory(folder).toString());
            }
            for (VirtualFile rootFile : files = ((OrderEntry)orderEntries.get(0)).getFiles(OrderRootType.CLASSES)) {
                VirtualFile classFile = rootFile.findFileByRelativePath(relativePath);
                if (classFile == null) continue;
                return this.getLanguageLevel(classFile);
            }
        }
        return LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel();
    }

    private LanguageLevel getLanguageLevel(VirtualFile dirFile) {
        VirtualFile[] children = dirFile.getChildren();
        LanguageLevel defaultLanguageLevel = LanguageLevelProjectExtension.getInstance((Project)this.getProject()).getLanguageLevel();
        for (VirtualFile child : children) {
            PsiFile psiFile;
            if (!StdFileTypes.CLASS.equals(child.getFileType()) || !((psiFile = this.getManager().findFile(child)) instanceof PsiJavaFile)) continue;
            return ((PsiJavaFile)psiFile).getLanguageLevel();
        }
        return defaultLanguageLevel;
    }

    private static class MyResolveCacheProcessor
    implements Processor<ClassCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor, ResolveState state) {
            this.myProcessor = processor;
            this.myState = state;
        }

        public boolean process(ClassCollectingProcessor.ResultWithContext result) {
            this.myProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)result.getFileContext());
            return this.myProcessor.execute((PsiElement)result.getElement(), this.myState);
        }
    }

    private class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, ClassCollectingProcessor.ResultWithContext>> {
        private MyCacheBuilder() {
        }

        public CachedValueProvider.Result<MostlySingularMultiMap<String, ClassCollectingProcessor.ResultWithContext>> compute() {
            ClassCollectingProcessor p = new ClassCollectingProcessor();
            PsiJavaFileBaseImpl.this.processDeclarationsNoGuess(p, ResolveState.initial(), (PsiElement)PsiJavaFileBaseImpl.this, (PsiElement)PsiJavaFileBaseImpl.this);
            return new CachedValueProvider.Result(p.getResults(), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private String myNameToFilter;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenNames = new HashSet();

        private StaticImportFilteringProcessor(PsiScopeProcessor delegate, String nameToFilter) {
            this.myDelegate = delegate;
            this.myNameToFilter = nameToFilter;
        }

        public void setNameToFilter(String nameToFilter) {
            this.myNameToFilter = nameToFilter;
        }

        public <T> T getHint(Key<T> hintKey) {
            return (T)this.myDelegate.getHint(hintKey);
        }

        public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
                if (associated instanceof PsiImportStaticStatement) {
                    PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                    if (importStaticStatement.isOnDemand()) {
                        this.myIsProcessingOnDemand = true;
                    } else {
                        this.myIsProcessingOnDemand = false;
                        this.myHiddenNames.add(importStaticStatement.getReferenceName());
                    }
                } else {
                    this.myIsProcessingOnDemand = false;
                }
            }
            this.myDelegate.handleEvent(event, associated);
        }

        public boolean execute(PsiElement element, ResolveState state) {
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                String name;
                if (!(this.myNameToFilter == null || element instanceof PsiNamedElement && this.myNameToFilter.equals(((PsiNamedElement)element).getName()))) {
                    return true;
                }
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand && this.myHiddenNames.contains(name = ((PsiNamedElement)element).getName())) {
                    return true;
                }
                return this.myDelegate.execute(element, state);
            }
            return true;
        }
    }
}

