/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.annotations.NonNls;

public class PsiExpressionCodeFragmentImpl
extends PsiCodeFragmentImpl
implements PsiExpressionCodeFragment {
    private PsiType myExpectedType;

    public PsiExpressionCodeFragmentImpl(Project project, boolean isPhysical, @NonNls String name, CharSequence text, PsiType expectedType) {
        super(project, JavaElementType.EXPRESSION_TEXT, isPhysical, name, text);
        this.myExpectedType = expectedType;
    }

    public PsiExpression getExpression() {
        ASTNode exprChild = this.calcTreeElement().findChildByType(Constants.EXPRESSION_BIT_SET);
        if (exprChild == null) {
            return null;
        }
        return (PsiExpression)SourceTreeToPsiMap.treeElementToPsi(exprChild);
    }

    public PsiType getExpectedType() {
        return this.myExpectedType;
    }

    public void setExpectedType(PsiType type) {
        this.myExpectedType = type;
    }
}

