/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBus;

public class PsiModificationTrackerImpl
implements PsiModificationTracker,
PsiTreeChangePreprocessor {
    private volatile long myModificationCount = 0L;
    private volatile long myOutOfCodeBlockModificationCount = 0L;
    private volatile long myJavaStructureModificationCount = 0L;
    private volatile long myAnnotationModificationCount = 0L;
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(Project project) {
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(ProjectTopics.MODIFICATION_TRACKER);
        bus.connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiModificationTrackerImpl.this.incCounter();
                    }
                });
            }

            public void exitDumbMode() {
                this.enteredDumbMode();
            }
        });
    }

    public void incCounter() {
        ++this.myModificationCount;
        ++this.myJavaStructureModificationCount;
        this.incOutOfCodeBlockModificationCounter();
    }

    public void incOutOfCodeBlockModificationCounter() {
        ++this.myOutOfCodeBlockModificationCount;
        this.myPublisher.modificationCountChanged();
    }

    public void incAnnotationModificationCounter() {
        ++this.myAnnotationModificationCount;
    }

    @Override
    public void treeChanged(PsiTreeChangeEventImpl event) {
        ++this.myModificationCount;
        if (event.getParent() instanceof PsiDirectory) {
            this.incOutOfCodeBlockModificationCounter();
        }
        this.myPublisher.modificationCountChanged();
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    public long getOutOfCodeBlockModificationCount() {
        return this.myOutOfCodeBlockModificationCount;
    }

    public long getJavaStructureModificationCount() {
        return this.myJavaStructureModificationCount;
    }

    public long getAnnotationModificationCount() {
        return this.myAnnotationModificationCount;
    }
}

