/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.DelegatingFormattingModelBuilder;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlBlock
extends AbstractBlock {
    protected XmlFormattingPolicy myXmlFormattingPolicy;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.xml.AbstractXmlBlock");

    protected AbstractXmlBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy) {
        super(node, wrap, alignment);
        this.myXmlFormattingPolicy = policy;
        if (node == null) {
            LOG.assertTrue(false);
        }
        if (node.getTreeParent() == null) {
            this.myXmlFormattingPolicy.setRootBlock(node, (Block)this);
        }
    }

    protected static WrapType getWrapType(int type) {
        if (type == 0) {
            return WrapType.NONE;
        }
        if (type == 2) {
            return WrapType.ALWAYS;
        }
        if (type == 1) {
            return WrapType.NORMAL;
        }
        return WrapType.CHOP_DOWN_IF_LONG;
    }

    protected Alignment chooseAlignment(ASTNode child, Alignment attrAlignment, Alignment textAlignment) {
        if (this.myNode.getElementType() == XmlElementType.XML_TEXT) {
            return this.getAlignment();
        }
        IElementType elementType = child.getElementType();
        if (elementType == XmlElementType.XML_ATTRIBUTE && this.myXmlFormattingPolicy.getShouldAlignAttributes()) {
            return attrAlignment;
        }
        if (elementType == XmlElementType.XML_TEXT && this.myXmlFormattingPolicy.getShouldAlignText()) {
            return textAlignment;
        }
        return null;
    }

    private Wrap getTagEndWrapping(XmlTag parent) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagEnd(parent), (boolean)true);
    }

    protected Wrap chooseWrap(ASTNode child, Wrap tagBeginWrap, Wrap attrWrap, Wrap textWrap) {
        if (this.myNode.getElementType() == XmlElementType.XML_TEXT) {
            return textWrap;
        }
        IElementType elementType = child.getElementType();
        if (elementType == XmlElementType.XML_ATTRIBUTE) {
            return attrWrap;
        }
        if (elementType == XmlElementType.XML_START_TAG_START) {
            return tagBeginWrap;
        }
        if (elementType == XmlElementType.XML_END_TAG_START) {
            XmlTag tag;
            PsiElement parent = SourceTreeToPsiMap.treeElementToPsi(child.getTreeParent());
            if (parent instanceof XmlTag && this.canWrapTagEnd(tag = (XmlTag)parent)) {
                return this.getTagEndWrapping(tag);
            }
            return null;
        }
        if (elementType == XmlElementType.XML_TEXT || elementType == XmlElementType.XML_DATA_CHARACTERS) {
            return textWrap;
        }
        return null;
    }

    protected boolean canWrapTagEnd(XmlTag tag) {
        return tag.getSubTags().length > 0;
    }

    protected XmlTag getTag() {
        return AbstractXmlBlock.getTag(this.myNode);
    }

    protected static XmlTag getTag(ASTNode node) {
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(node);
        if (element instanceof XmlTag) {
            return (XmlTag)element;
        }
        return null;
    }

    protected Wrap createTagBeginWrapping(XmlTag tag) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagBegin(tag), (boolean)true);
    }

    @Nullable
    protected ASTNode processChild(List<Block> result, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        PsiElement childPsi;
        Language childLanguage;
        Language myLanguage = this.myNode.getPsi().getLanguage();
        if (this.useMyFormatter(myLanguage, childLanguage = (childPsi = child.getPsi()).getLanguage(), childPsi)) {
            XmlTag tag = this.getAnotherTreeTag(child);
            if (tag != null && this.containsTag((PsiElement)tag) && this.doesNotIntersectSubTagsWith((PsiElement)tag)) {
                ASTNode currentChild = this.createAnotherTreeNode(result, child, (PsiElement)tag, indent, wrap, alignment);
                if (currentChild == null) {
                    return null;
                }
                while (currentChild != null && currentChild.getTreeParent() != this.myNode && currentChild.getTreeParent() != child.getTreeParent()) {
                    if ((currentChild = this.processAllChildrenFrom(result, currentChild, wrap, alignment, indent)) != null && (currentChild.getTreeParent() == this.myNode || currentChild.getTreeParent() == child.getTreeParent())) {
                        return currentChild;
                    }
                    if (currentChild == null) continue;
                    currentChild = currentChild.getTreeParent();
                }
                return currentChild;
            }
            this.processSimpleChild(child, indent, result, wrap, alignment);
            return child;
        }
        return this.createAnotherLanguageBlockWrapper(childLanguage, child, result, indent, 0, null);
    }

    protected boolean doesNotIntersectSubTagsWith(PsiElement tag) {
        XmlTag[] subTags;
        TextRange tagRange = tag.getTextRange();
        for (XmlTag subTag : subTags = this.getSubTags()) {
            TextRange subTagRange = subTag.getTextRange();
            if (subTagRange.getEndOffset() < tagRange.getStartOffset()) continue;
            if (subTagRange.getStartOffset() > tagRange.getEndOffset()) {
                return true;
            }
            if (tagRange.getStartOffset() > subTagRange.getStartOffset() && tagRange.getEndOffset() < subTagRange.getEndOffset()) {
                return false;
            }
            if (tagRange.getEndOffset() <= subTagRange.getStartOffset() || tagRange.getEndOffset() >= subTagRange.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    private XmlTag[] getSubTags() {
        if (this.myNode instanceof XmlTag) {
            return ((XmlTag)this.myNode.getPsi()).getSubTags();
        }
        if (this.myNode.getPsi() instanceof XmlElement) {
            return AbstractXmlBlock.collectSubTags((XmlElement)this.myNode.getPsi());
        }
        return new XmlTag[0];
    }

    private static XmlTag[] collectSubTags(XmlElement node) {
        final ArrayList result = new ArrayList();
        node.processElements(new PsiElementProcessor(){

            public boolean execute(PsiElement element) {
                if (element instanceof XmlTag) {
                    result.add((XmlTag)element);
                }
                return true;
            }
        }, (PsiElement)node);
        return result.toArray(new XmlTag[result.size()]);
    }

    protected boolean containsTag(PsiElement tag) {
        ASTNode closingTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myNode);
        ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(this.myNode);
        if (closingTagStart == null && startTagStart == null) {
            return tag.getTextRange().getEndOffset() <= this.myNode.getTextRange().getEndOffset();
        }
        if (closingTagStart == null) {
            return false;
        }
        return tag.getTextRange().getEndOffset() <= closingTagStart.getTextRange().getEndOffset();
    }

    private ASTNode processAllChildrenFrom(List<Block> result, @NotNull ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/formatter/xml/AbstractXmlBlock.processAllChildrenFrom must not be null");
        }
        ASTNode resultNode = child;
        ASTNode currentChild = child.getTreeNext();
        while (currentChild != null && currentChild.getElementType() != XmlElementType.XML_END_TAG_START) {
            if (!FormatterUtil.containsWhiteSpacesOnly(currentChild)) {
                resultNode = currentChild = this.processChild(result, currentChild, wrap, alignment, indent);
            }
            if (currentChild == null) continue;
            currentChild = currentChild.getTreeNext();
        }
        return resultNode;
    }

    protected void processSimpleChild(ASTNode child, Indent indent, List<Block> result, Wrap wrap, Alignment alignment) {
        if (this.isXmlTag(child)) {
            result.add((Block)this.createTagBlock(child, indent != null ? indent : Indent.getNoneIndent(), wrap, alignment));
        } else if (child.getElementType() == XmlElementType.XML_DOCTYPE) {
            result.add((Block)new XmlBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, null){

                @Override
                protected Wrap getDefaultWrap(ASTNode node) {
                    IElementType type = node.getElementType();
                    return type == XmlElementType.XML_ATTRIBUTE_VALUE_TOKEN ? Wrap.createWrap((WrapType)2.getWrapType(this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false) : null;
                }
            });
        } else {
            result.add((Block)this.createSimpleChild(child, indent, wrap, alignment));
        }
    }

    protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new XmlBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, null);
    }

    protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new XmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent());
    }

    protected ASTNode createAnotherLanguageBlockWrapper(Language childLanguage, ASTNode child, List<Block> result, Indent indent, int offset, @Nullable TextRange range) {
        PsiElement childPsi = child.getPsi();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext(childLanguage, childPsi);
        LOG.assertTrue(builder != null);
        FormattingModel childModel = builder.createModel(childPsi, this.getSettings());
        Block original = childModel.getRootBlock();
        if (original.isLeaf() && child.getText().trim().length() > 0 || original.getSubBlocks().size() != 0) {
            result.add((Block)new AnotherLanguageBlockWrapper(child, this.myXmlFormattingPolicy, original, indent, offset, range));
        }
        return child;
    }

    @Nullable
    protected XmlTag findXmlTagAt(ASTNode child, int startOffset) {
        return null;
    }

    @Nullable
    protected ASTNode createAnotherTreeNode(List<Block> result, ASTNode child, PsiElement tag, Indent indent, Wrap wrap, Alignment alignment) {
        return null;
    }

    @Nullable
    protected Block createAnotherTreeTagBlock(PsiElement tag, Indent childIndent) {
        return null;
    }

    protected XmlFormattingPolicy createPolicyFor() {
        return this.myXmlFormattingPolicy;
    }

    private CodeStyleSettings getSettings() {
        return this.myXmlFormattingPolicy.getSettings();
    }

    @Nullable
    protected XmlTag getAnotherTreeTag(ASTNode child) {
        return null;
    }

    protected boolean isXmlTag(ASTNode child) {
        return this.isXmlTag(child.getPsi());
    }

    protected boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag;
    }

    protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
        if (myLanguage == childLanguage || childLanguage == StdFileTypes.HTML.getLanguage() || childLanguage == StdFileTypes.XHTML.getLanguage() || childLanguage == StdFileTypes.XML.getLanguage()) {
            return true;
        }
        FormattingModelBuilder childFormatter = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(childLanguage);
        return childFormatter == null || childFormatter instanceof DelegatingFormattingModelBuilder && ((DelegatingFormattingModelBuilder)childFormatter).dontFormatMyModel();
    }

    protected boolean isJspxJavaContainingNode(ASTNode child) {
        return false;
    }

    public abstract boolean insertLineBreakBeforeTag();

    public abstract boolean removeLineBreakBeforeTag();

    protected Spacing createDefaultSpace(boolean forceKeepLineBreaks, boolean inText) {
        boolean shouldKeepLineBreaks = this.getShouldKeepLineBreaks(inText, forceKeepLineBreaks);
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)shouldKeepLineBreaks, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
    }

    private boolean getShouldKeepLineBreaks(boolean inText, boolean forceKeepLineBreaks) {
        if (forceKeepLineBreaks) {
            return true;
        }
        if (inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText()) {
            return true;
        }
        return !inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaks();
    }

    public abstract boolean isTextElement();

    protected void createJspTextNode(List<Block> localResult, ASTNode child, Indent indent) {
    }

    @Nullable
    protected static ASTNode findChildAfter(@NotNull ASTNode child, int endOffset) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/formatter/xml/AbstractXmlBlock.findChildAfter must not be null");
        }
        FileElement fileNode = TreeUtil.getFileElement((TreeElement)child);
        LeafElement leaf = ((TreeElement)fileNode).findLeafElementAt(endOffset);
        if (leaf != null && leaf.getStartOffset() == endOffset && endOffset > 0) {
            return ((TreeElement)fileNode).findLeafElementAt(endOffset - 1);
        }
        return leaf;
    }

    public boolean isLeaf() {
        return AbstractXmlBlock.isComment(this.myNode) || this.myNode.getElementType() == TokenType.WHITE_SPACE || this.myNode.getElementType() == XmlElementType.XML_DATA_CHARACTERS || this.myNode.getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean isComment(ASTNode node) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(node);
        if (psiElement instanceof PsiComment) {
            return true;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(psiElement.getLanguage());
        if (parserDefinition == null) {
            return false;
        }
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        return commentTokens.contains(node.getElementType());
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myXmlFormattingPolicy = xmlFormattingPolicy;
    }
}

