/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArtifactImpl
extends UserDataHolderBase
implements ModifiableArtifact {
    private CompositePackagingElement<?> myRootElement;
    private String myName;
    private boolean myBuildOnMake;
    private String myOutputPath;
    private final EventDispatcher<ArtifactListener> myDispatcher;
    private ArtifactType myArtifactType;
    private Map<ArtifactPropertiesProvider, ArtifactProperties<?>> myProperties;

    public ArtifactImpl(@NotNull String name, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.<init> must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.<init> must not be null");
        }
        if (rootElement == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.<init> must not be null");
        }
        this(name, artifactType, buildOnMake, rootElement, outputPath, null);
    }

    public ArtifactImpl(@NotNull String name, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath, EventDispatcher<ArtifactListener> dispatcher) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.<init> must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.<init> must not be null");
        }
        if (rootElement == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.<init> must not be null");
        }
        this.myName = name;
        this.myArtifactType = artifactType;
        this.myBuildOnMake = buildOnMake;
        this.myRootElement = rootElement;
        this.myOutputPath = outputPath;
        this.myDispatcher = dispatcher;
        this.myProperties = new HashMap();
        this.resetProperties();
    }

    private void resetProperties() {
        this.myProperties.clear();
        for (ArtifactPropertiesProvider provider : ArtifactPropertiesProvider.getProviders()) {
            if (!provider.isAvailableFor(this.myArtifactType)) continue;
            this.myProperties.put(provider, provider.createProperties(this.myArtifactType));
        }
    }

    @NotNull
    public ArtifactType getArtifactType() {
        ArtifactType artifactType = this.myArtifactType;
        if (artifactType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactImpl.getArtifactType must not return null");
        }
        return artifactType;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    @NotNull
    public CompositePackagingElement<?> getRootElement() {
        CompositePackagingElement<?> compositePackagingElement = this.myRootElement;
        if (compositePackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactImpl.getRootElement must not return null");
        }
        return compositePackagingElement;
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    public Collection<? extends ArtifactPropertiesProvider> getPropertiesProviders() {
        return Collections.unmodifiableCollection(this.myProperties.keySet());
    }

    public ArtifactImpl createCopy(EventDispatcher<ArtifactListener> dispatcher) {
        ArtifactImpl artifact = new ArtifactImpl(this.myName, this.myArtifactType, this.myBuildOnMake, this.myRootElement, this.myOutputPath, dispatcher);
        for (Map.Entry<ArtifactPropertiesProvider, ArtifactProperties<?>> entry : this.myProperties.entrySet()) {
            ArtifactProperties<?> newProperties = artifact.myProperties.get(entry.getKey());
            newProperties.loadState(entry.getValue().getState());
        }
        return artifact;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.setName must not be null");
        }
        String oldName = this.myName;
        this.myName = name;
        if (this.myDispatcher != null) {
            ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged((Artifact)this, oldName);
        }
    }

    @NonNls
    public String toString() {
        return "artifact:" + this.myName;
    }

    public void setRootElement(CompositePackagingElement<?> root) {
        this.myRootElement = root;
    }

    public void setProperties(ArtifactPropertiesProvider provider, ArtifactProperties<?> properties) {
        if (properties != null) {
            this.myProperties.put(provider, properties);
        } else {
            this.myProperties.remove(provider);
        }
    }

    public void setArtifactType(@NotNull ArtifactType selected) {
        if (selected == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.setArtifactType must not be null");
        }
        this.myArtifactType = selected;
        this.resetProperties();
    }

    public void setBuildOnMake(boolean buildOnMake) {
        this.myBuildOnMake = buildOnMake;
    }

    public void setOutputPath(String outputPath) {
        this.myOutputPath = outputPath;
    }

    public ArtifactProperties<?> getProperties(@NotNull ArtifactPropertiesProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactImpl.getProperties must not be null");
        }
        return this.myProperties.get(provider);
    }

    public void copyFrom(ArtifactImpl modified) {
        this.myName = modified.getName();
        this.myOutputPath = modified.getOutputPath();
        this.myBuildOnMake = modified.isBuildOnMake();
        this.myRootElement = modified.getRootElement();
        this.myProperties = modified.myProperties;
        this.myArtifactType = modified.getArtifactType();
    }
}

