/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfo;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class RestoreUpdateTree
implements ProjectComponent,
JDOMExternalizable {
    private final Project myProject;
    private UpdateInfo myUpdateInfo;
    @NonNls
    private static final String UPDATE_INFO = "UpdateInfo";

    public RestoreUpdateTree(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (RestoreUpdateTree.this.myUpdateInfo != null && !RestoreUpdateTree.this.myUpdateInfo.isEmpty() && ProjectReloadState.getInstance((Project)RestoreUpdateTree.this.myProject).isAfterAutomaticReload()) {
                    ActionInfo actionInfo = RestoreUpdateTree.this.myUpdateInfo.getActionInfo();
                    if (actionInfo != null) {
                        ProjectLevelVcsManagerEx.getInstanceEx(RestoreUpdateTree.this.myProject).showUpdateProjectInfo(RestoreUpdateTree.this.myUpdateInfo.getFileInformation(), VcsBundle.message((String)"action.display.name.update", (Object[])new Object[0]), actionInfo);
                        CommittedChangesCache.getInstance(RestoreUpdateTree.this.myProject).refreshIncomingChangesAsync();
                    }
                    RestoreUpdateTree.this.myUpdateInfo = null;
                } else {
                    RestoreUpdateTree.this.myUpdateInfo = null;
                }
            }
        });
    }

    public void projectClosed() {
    }

    public String getComponentName() {
        return "RestoreUpdateTree";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element child = element.getChild(UPDATE_INFO);
        if (child != null) {
            UpdateInfo updateInfo = new UpdateInfo(this.myProject);
            updateInfo.readExternal(child);
            this.myUpdateInfo = updateInfo;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myUpdateInfo != null) {
            Element child = new Element(UPDATE_INFO);
            element.addContent(child);
            this.myUpdateInfo.writeExternal(child);
        }
    }

    public static RestoreUpdateTree getInstance(Project project) {
        return (RestoreUpdateTree)project.getComponent(RestoreUpdateTree.class);
    }

    public void registerUpdateInformation(UpdatedFiles updatedFiles, ActionInfo actionInfo) {
        this.myUpdateInfo = new UpdateInfo(this.myProject, updatedFiles, actionInfo);
    }
}

