/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.ui.AdditionalLocalChangeActionsInstaller;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserExtender;
import com.intellij.openapi.vcs.changes.ui.EditSourceInCommitAction;
import com.intellij.openapi.vcs.changes.ui.SelectedListChangeListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleChangeListBrowser
extends ChangesBrowser {
    private final ChangeListChooser myChangeListChooser;
    private final ChangeListListener myChangeListListener = new MyChangeListListener();
    private final boolean myShowingAllChangeLists;
    private final EventDispatcher<SelectedListChangeListener> myDispatcher = EventDispatcher.create(SelectedListChangeListener.class);
    private Collection<Change> myAllChanges;
    private Map<Change, LocalChangeList> myChangeListsMap;
    private final ChangesBrowserExtender myExtender;
    private final Runnable myRebuildListListener;
    private boolean myInRebuildList;

    public MultipleChangeListBrowser(Project project, List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, Runnable rebuildListListener, @Nullable Runnable inclusionListener) {
        super(project, changeLists, changes, initialListSelection, capableOfExcludingChanges, highlightProblems, inclusionListener, ChangesBrowser.MyUseCase.LOCAL_CHANGES);
        this.myRebuildListListener = rebuildListListener;
        this.myChangeListChooser = new ChangeListChooser(changeLists);
        this.myHeaderPanel.add((Component)this.myChangeListChooser, "East");
        this.myShowingAllChangeLists = Comparing.haveEqualElements(changeLists, (Collection)ChangeListManager.getInstance((Project)project).getChangeLists());
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener(this.myChangeListListener);
        this.myExtender = new Extender(project, this);
    }

    @Override
    protected void setInitialSelection(List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection) {
        this.myAllChanges = new ArrayList<Change>();
        this.mySelectedChangeList = initialListSelection;
        block0: for (ChangeList changeList : changeLists) {
            if (!(changeList instanceof LocalChangeList)) continue;
            this.myAllChanges.addAll(changeList.getChanges());
            if (initialListSelection != null) continue;
            for (Change c : changeList.getChanges()) {
                if (!changes.contains(c)) continue;
                this.mySelectedChangeList = changeList;
                continue block0;
            }
        }
        if (this.mySelectedChangeList == null) {
            for (ChangeList changeList : changeLists) {
                if (!(changeList instanceof LocalChangeList) || !((LocalChangeList)changeList).isDefault()) continue;
                this.mySelectedChangeList = changeList;
                break;
            }
            if (this.mySelectedChangeList == null && !changeLists.isEmpty()) {
                this.mySelectedChangeList = changeLists.get(0);
            }
        }
    }

    @Override
    public void dispose() {
        ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener(this.myChangeListListener);
    }

    public Collection<Change> getAllChanges() {
        return this.myAllChanges;
    }

    public ChangesBrowserExtender getExtender() {
        return this.myExtender;
    }

    public void addSelectedListChangeListener(SelectedListChangeListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeSelectedListChangeListener(SelectedListChangeListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private void setSelectedList(ChangeList list) {
        this.mySelectedChangeList = list;
        this.rebuildList();
        ((SelectedListChangeListener)this.myDispatcher.getMulticaster()).selectedListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildList() {
        if (this.myInRebuildList) {
            return;
        }
        try {
            this.myInRebuildList = true;
            if (this.myChangesToDisplay == null) {
                ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
                this.myChangeListsMap = new HashMap<Change, LocalChangeList>();
                List lists = manager.getChangeListsCopy();
                ArrayList<Change> allChanges = new ArrayList<Change>();
                for (LocalChangeList list : lists) {
                    Collection changes = list.getChanges();
                    allChanges.addAll(changes);
                    for (Change change : changes) {
                        this.myChangeListsMap.put(change, list);
                    }
                }
                this.myAllChanges = allChanges;
                this.updateListsInChooser();
            }
            super.rebuildList();
            if (this.myRebuildListListener != null) {
                this.myRebuildListListener.run();
            }
        }
        finally {
            this.myInRebuildList = false;
        }
    }

    @Override
    public List<Change> getCurrentDisplayedChanges() {
        if (this.myChangesToDisplay == null) {
            return MultipleChangeListBrowser.sortChanges(this.filterBySelectedChangeList(this.myAllChanges));
        }
        return super.getCurrentDisplayedChanges();
    }

    @NotNull
    public List<Change> getCurrentIncludedChanges() {
        List<Change> list = this.filterBySelectedChangeList(this.myViewer.getIncludedChanges());
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser.getCurrentIncludedChanges must not return null");
        }
        return list;
    }

    private List<Change> filterBySelectedChangeList(Collection<Change> changes) {
        ArrayList<Change> filtered = new ArrayList<Change>();
        for (Change change : changes) {
            if (!Comparing.equal((Object)this.getList(change), (Object)this.mySelectedChangeList)) continue;
            filtered.add(change);
        }
        return filtered;
    }

    private ChangeList getList(Change change) {
        return (ChangeList)this.myChangeListsMap.get(change);
    }

    @Override
    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        super.buildToolBar(toolBarGroup);
        MoveChangesToAnotherListAction moveAction = new MoveChangesToAnotherListAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                super.actionPerformed(e);
                MultipleChangeListBrowser.this.rebuildList();
            }
        };
        moveAction.registerCustomShortcutSet(CommonShortcuts.getMove(), this.myViewer);
        toolBarGroup.add((AnAction)moveAction);
    }

    @Override
    protected List<AnAction> createDiffActions(Change change) {
        List<AnAction> actions = super.createDiffActions(change);
        actions.add(new MoveAction(change));
        return actions;
    }

    private void updateListsInChooser() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (MultipleChangeListBrowser.this.myChangeListChooser != null && MultipleChangeListBrowser.this.myShowingAllChangeLists) {
                    MultipleChangeListBrowser.this.myChangeListChooser.updateLists(ChangeListManager.getInstance((Project)MultipleChangeListBrowser.this.myProject).getChangeListsCopy());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)this));
        }
    }

    private static class Extender
    implements ChangesBrowserExtender {
        private final Project myProject;
        private final MultipleChangeListBrowser myBrowser;

        private Extender(Project project, MultipleChangeListBrowser browser) {
            this.myProject = project;
            this.myBrowser = browser;
        }

        @Override
        public void addToolbarActions(DialogWrapper dialogWrapper) {
            final Icon icon = IconLoader.getIcon((String)"/vcs/refresh.png");
            if (this.myBrowser.myChangesToDisplay == null) {
                this.myBrowser.addToolbarAction(new AnAction("Refresh Changes"){

                    public void actionPerformed(AnActionEvent e) {
                        Extender.this.myBrowser.rebuildList();
                    }

                    public void update(AnActionEvent e) {
                        e.getPresentation().setIcon(icon);
                    }
                });
            }
            this.myBrowser.addToolbarAction(new RollbackDialogAction());
            EditSourceInCommitAction editSourceAction = new EditSourceInCommitAction(dialogWrapper);
            editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myBrowser);
            this.myBrowser.addToolbarAction(editSourceAction);
            this.myBrowser.addToolbarAction(ActionManager.getInstance().getAction("Vcs.CheckinProjectToolbar"));
            List<AnAction> actions = AdditionalLocalChangeActionsInstaller.calculateActions(this.myProject, this.myBrowser.getAllChanges());
            if (actions != null) {
                for (AnAction action : actions) {
                    this.myBrowser.addToolbarAction(action);
                }
            }
        }

        @Override
        public void addSelectedListChangeListener(SelectedListChangeListener listener) {
            this.myBrowser.addSelectedListChangeListener(listener);
        }

        @Override
        public List<AbstractVcs> getAffectedVcses() {
            HashSet<AbstractVcs> result = new HashSet<AbstractVcs>();
            for (Change change : this.myBrowser.myAllChanges) {
                AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myBrowser.myProject);
                if (vcs == null) continue;
                result.add(vcs);
            }
            return new ArrayList<AbstractVcs>(result);
        }

        @Override
        public List<Change> getCurrentIncludedChanges() {
            return this.myBrowser.getCurrentIncludedChanges();
        }
    }

    private class MoveAction
    extends MoveChangesToAnotherListAction {
        private final Change myChange;

        public MoveAction(Change change) {
            this.myChange = change;
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            MoveAction.askAndMove(MultipleChangeListBrowser.this.myProject, new Change[]{this.myChange}, null);
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListAdded(ChangeList list) {
            MultipleChangeListBrowser.this.updateListsInChooser();
        }
    }

    private class ChangeListChooser
    extends JPanel {
        private final JComboBox myChooser;
        private static final int MAX_LEN = 35;

        public ChangeListChooser(List<? extends ChangeList> lists) {
            super(new BorderLayout());
            this.myChooser = new JComboBox(){

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(0, 0);
                }
            };
            this.myChooser.setRenderer(new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    LocalChangeList l = (LocalChangeList)value;
                    if (l != null) {
                        String name = l.getName().trim();
                        if (name.length() > 35) {
                            name = name.substring(0, 32) + "...";
                        }
                        this.append(name, l.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
            this.myChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LocalChangeList changeList = (LocalChangeList)ChangeListChooser.this.myChooser.getSelectedItem();
                        MultipleChangeListBrowser.this.setSelectedList((ChangeList)changeList);
                        ChangeListChooser.this.myChooser.setToolTipText(changeList == null ? "" : changeList.getName());
                    }
                }
            });
            this.updateLists(lists);
            this.myChooser.setEditable(false);
            this.add((Component)this.myChooser, "Center");
            JLabel label = new JLabel(VcsBundle.message((String)"commit.dialog.changelist.label", (Object[])new Object[0]));
            label.setDisplayedMnemonic('l');
            label.setLabelFor(this.myChooser);
            this.add((Component)label, "West");
        }

        public void updateLists(List<? extends ChangeList> lists) {
            this.myChooser.setModel(new DefaultComboBoxModel<Object>(lists.toArray()));
            this.myChooser.setEnabled(lists.size() > 1);
            if (lists.contains(MultipleChangeListBrowser.this.mySelectedChangeList)) {
                this.myChooser.setSelectedItem(MultipleChangeListBrowser.this.mySelectedChangeList);
            } else if (this.myChooser.getItemCount() > 0) {
                this.myChooser.setSelectedIndex(0);
            }
            MultipleChangeListBrowser.this.mySelectedChangeList = (ChangeList)this.myChooser.getSelectedItem();
        }
    }
}

