/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutTreeSelection {
    private List<PackagingElementNode<?>> mySelectedNodes;
    private List<PackagingElement<?>> mySelectedElements;
    private Map<PackagingElement<?>, PackagingElementNode<?>> myElement2Node;
    private Map<PackagingElementNode<?>, TreePath> myNode2Path;

    public LayoutTreeSelection(@NotNull LayoutTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeSelection.<init> must not be null");
        }
        this.mySelectedNodes = new ArrayList();
        this.mySelectedElements = new ArrayList();
        this.myElement2Node = new HashMap();
        this.myNode2Path = new HashMap();
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            SimpleNode node = tree.getNodeFor(path);
            if (!(node instanceof PackagingElementNode)) continue;
            PackagingElementNode elementNode = (PackagingElementNode)node;
            this.mySelectedNodes.add(elementNode);
            this.myNode2Path.put(elementNode, path);
            for (PackagingElement element : elementNode.getPackagingElements()) {
                this.mySelectedElements.add(element);
                this.myElement2Node.put(element, elementNode);
            }
        }
    }

    public List<PackagingElementNode<?>> getNodes() {
        return this.mySelectedNodes;
    }

    public List<PackagingElement<?>> getElements() {
        return this.mySelectedElements;
    }

    public PackagingElementNode<?> getNode(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeSelection.getNode must not be null");
        }
        return this.myElement2Node.get(element);
    }

    public TreePath getPath(@NotNull PackagingElementNode<?> node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeSelection.getPath must not be null");
        }
        return this.myNode2Path.get(node);
    }

    @Nullable
    public CompositePackagingElement<?> getCommonParentElement() {
        CompositePackagingElement<?> commonParent = null;
        for (PackagingElementNode<?> selectedNode : this.mySelectedNodes) {
            Object element = selectedNode.getElementIfSingle();
            if (element == null) {
                return null;
            }
            CompositePackagingElement<?> parentElement = selectedNode.getParentElement((PackagingElement<?>)element);
            if (parentElement == null || commonParent != null && !commonParent.equals(parentElement)) {
                return null;
            }
            commonParent = parentElement;
        }
        return commonParent;
    }

    @Nullable
    public PackagingElement<?> getElementIfSingle() {
        return this.mySelectedElements.size() == 1 ? this.mySelectedElements.get(0) : null;
    }

    @Nullable
    public PackagingElementNode<?> getNodeIfSingle() {
        return this.mySelectedNodes.size() == 1 ? this.mySelectedNodes.get(0) : null;
    }
}

